#!/usr/bin/perl
#use strict;
#use warnings;

my $bin = "/opt/interm/bin";
my $conf = "/opt/interm/conf";
my $xml_util = "$bin/xml_util";

my $oper_xml_file = "oper_mode.xml";
my $oper_mode_path = "/config/type";

my $dir = "/mnt/removable_disk";
my $playlist = $dir . "/" . "playlist.m3u";

$oper_mode=`$xml_util -r -f $conf/$oper_xml_file -t $oper_mode_path`;
exit 1 if $? != 0;

=pod

opendir my $dh, $dir;

foreach (readdir($dh)) {
	print "$_\n";
}
=cut

open my $fh, ">", $playlist;

print $fh "#EXTM3U\n";
foreach (map { chomp; $_ } qx!find $dir -type f -name '*.mp3' -o -name '*.flac' -o -name '*.wma' -o -name '*.aac' -o -name '*.mp2' -o -name '*.ogg' -o -name '*.wav'!) {
	#s/$dir\///g;
	print $fh $_, "\n";
}

close $fh;

if (-f $playlist) {
	my $pid;
	$pid = fork();
	if ($pid == 0) {
		if ($oper_mode eq "usb") {
			qx!/opt/interm/bin/aplayer_ctrl -m usb -p $playlist!;
		}
	}
}

