#!/usr/bin/perl
#use strict;
#use warnings;

my $path = '/mnt/removable_disk';

die if $#ARGV == -1;

qx!mount -t auto -o iocharset=utf8 $ARGV[0] $path!;

my $fname = qx!find $path -maxdepth 1 -type f -regex "$path/pmun_Ver.*\.tar\.gz"!;
if ($fname =~ /pmun_Ver.*\.tar\.gz/) {
	$path = '/opt/interm';

	qx!/opt/interm/bin/aplayer_ctrl -m upgrade -p $fname!;

	my ($tarpath) = `cd $path; tar -zvxf $fname 2>/dev/null | head -n1`;

	if(length($tarpath) != 0) {
		$path .= "/";
		$tarpath =~ s/(.*\/)/$1/;
		chomp($tarpath);

		if(-x "${path}${tarpath}do") {
			`${path}${tarpath}do ${path}${tarpath}`;
			`rm -rf ${path}${tarpath}`;

			exit 0;
		}
	}
	else {
		qx!/opt/interm/bin/aplayer_ctrl -m upgrade!;
	}
}
else {
	my $pid;
	$pid = fork();
	if ($pid == 0) {
		qx!/opt/interm/bin/mkplaylist.pl!;
	}
}
