#!/usr/bin/perl
#use strict;
#use warnings;

print "Content-type: text/html\n\n";

my %in;

if (length ($ENV{'QUERY_STRING'}) > 0) {
	my $buffer = $ENV{'QUERY_STRING'};
	my @pairs = split /&/, $buffer;
	foreach my $pair (@pairs){
		(my $name, my $value) = split /=/, $pair;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$in{$name} = $value; 
	}
}

my $timeout = $in{'timeout'};
$timeout = 3 if $timeout eq "";

my $output = "Idx, MAC, IP Addr, Mask, Gateway, Hostname, HTTP Port, Media Port, Version, Link\n";
$output .= `/opt/interm/bin/scandevice -i eth0 -t $timeout`;
my @lines = split /\n/, $output;
my $firstLine = 0;
my $space = "&nbsp;";
my $style = "style=\"font-size:13px\"";

print "<html>\n";
print "<body>\n";
print "<table>\n";

my $lineCnt = 0;
foreach (@lines) {
	print "<tr>";
	my @line = split /, /, $_;
	if ($firstLine == 0) {
		foreach (@line) {
			print "<th align=\"left\"><p $style>$space $_ $space</p></th>";
		}
	}
	else {
		$firstLine = 1;
		unshift @line, $lineCnt;
		foreach (@line) {
			print "<td><p $style>$space $_ $space</p></td>";
		}
	}

	if ($firstLine != 0) {
		print "<td><p $style>$space <a href=\"http://$line[2]:$line[6]\" target=\"_blank\">http://$line[2]:$line[6]</a> $space</p></td>";
	}
	else {
		$firstLine = 1;
	}
	print "</tr>\n";
	$lineCnt += 1;
}

print "</table>\n";
print "</body>\n";
print "</html>\n";

