#ifndef __WRITELOG_H__
#define __WRITELOG_H__

#define E_ERROR					-1
#define E_SUCCESS				0

#define PATH_DFLT_LOG_FILE		"/opt/interm/www/html/log/"

#define SIZE_BUF_MSG			1024

#define SIZE_PARAMS				128
#define SIZE_FILE_PATH			256
#define SIZE_DFLT_LINE_COUNT	1024
#define SIZE_DFLT_LINE_LENGTH	1024
#define SIZE_DFLT_MEGA_SCALE	10
#define SIZE_DFLT_DUMP_WIDTH	16
#define SIZE_DUMP_SEPR_BYTE		8

#define NUM_DFLT_PERMISSION		777

#define STR_DFLT_FILE_OWNER		"www"

#define STR_LEVEL_DUMP			"DUMP"
#define STR_LEVEL_VERBOSE		"VERBOSE"
#define STR_LEVEL_INFO			"INFO"
#define STR_LEVEL_WARN			"WARN"
#define STR_LEVEL_ERROR			"ERROR"
#define STR_LEVEL_SYSTEM		"SYSTEM"
#define STR_LEVEL_COMM			"COMM"
#define STR_LEVEL_SLIENT		"SLIENT"

#define LEVEL_DUMP				0
#define LEVEL_VERBOSE			1
#define LEVEL_INFO				2
#define LEVEL_WARN				3
#define LEVEL_SYSTEM			4
#define LEVEL_ERROR				5
#define LEVEL_COMM				6
#define LEVEL_SLIENT			7

#define dump(LOG_INFO, name, data, len)		dump(STR_LEVEL_DUMP, LOG_INFO, name, data, len)
#define verbose(LOG_INFO, fmt, arg...)		verbose(STR_LEVEL_VERBOSE, LOG_INFO, fmt, ##arg)
#define info(LOG_INFO, fmt, arg...)			info(STR_LEVEL_INFO, LOG_INFO, fmt, ##arg)
#define wrn(LOG_INFO, fmt, arg...)			wrn(STR_LEVEL_WARN, LOG_INFO, fmt, ##arg)
#define err(LOG_INFO, fmt, arg...)			err(STR_LEVEL_ERROR, LOG_INFO, fmt, ##arg)
#define sys(LOG_INFO, fmt, arg...)			sys(STR_LEVEL_SYSTEM, LOG_INFO, fmt, ##arg)
#define comm(LOG_INFO, fmt, arg...)			comm(STR_LEVEL_COMM, LOG_INFO, fmt, ##arg)


struct LOG_FILE_INFO {
	char	logPath[SIZE_FILE_PATH];
	char	logName[SIZE_FILE_PATH];
	char	fileOwner[SIZE_PARAMS];
	char	filePerm[4];
	int		lineSize;
	int		lineCount;
	int		megaScale;
	int		logLevel;
	int		dumpWidth;
	FILE	*fp;
} typedef LOG_FILE_INFO_t;

struct WRITE_LOG {
	LOG_FILE_INFO_t logInfo;
	void (*dump)(const char *_mode, struct WRITE_LOG _this, const char *_dumpName, const char *_dumpData, int _dumpLen); 
	void (*verbose)(const char *_mode, struct WRITE_LOG _this, const char *_fmt, ...);
	void (*info)(const char *_mode, struct WRITE_LOG _this, const char *_fmt, ...);
	void (*wrn)(const char *_mode, struct WRITE_LOG _this, const char *_fmt, ...);
	void (*err)(const char *_mode, struct WRITE_LOG _this, const char *_fmt, ...);
	void (*sys)(const char *_mode, struct WRITE_LOG _this, const char *_fmt, ...);
	void (*comm)(const char *_mode, struct WRITE_LOG _this, const char *_fmt, ...);

	void (*setLogPath)(struct WRITE_LOG *_this, char *_logPath);
	void (*setLogName)(struct WRITE_LOG *_this, char *_logName);
	void (*setLogOwner)(struct WRITE_LOG *_this, char *_owner);
	void (*setLogPerm)(struct WRITE_LOG *_this, int _perm);
	void (*setLogLineSize)(struct WRITE_LOG *_this, int _lineSize);
	void (*setLogLineCount)(struct WRITE_LOG *_this, int _lineCount);
	void (*setLogMegaScale)(struct WRITE_LOG *_this, int _megaScale);
	void (*setLogLevel)(struct WRITE_LOG *_this, char *_mode);
	void (*setLogDumpWidth)(struct WRITE_LOG *_this, int _width);
} typedef WRITE_LOG_t;


void InitWriteLog(WRITE_LOG_t *_this, char *_logName);
void InitOffsetValue(WRITE_LOG_t *_this);
void InitOffsetValue(WRITE_LOG_t *_this);

void SetLogPath(WRITE_LOG_t *_this, char *_logPath);
void SetLogName(WRITE_LOG_t *_this, char *_logName);
void SetLogOwner(WRITE_LOG_t *_this, char *_owner);
void SetLogPerm(WRITE_LOG_t *_this, int _perm);
void SetLogLineCount(WRITE_LOG_t *_this, int _lineCount);
void SetLogLineSize(WRITE_LOG_t *_this, int _lineSize);
void SetLogMegaScale(WRITE_LOG_t *_this, int _lineCount);
void SetLogLevel(WRITE_LOG_t *_this, const char *_mode);
void SetLogDumpWidth(WRITE_LOG_t *_this, int _width);
void SetOffsetValue(WRITE_LOG_t *_this);
void SetLocOffset(WRITE_LOG_t *_this);

int  GetLogLevel(const char *_mode);
int  GetOffsetValue(FILE *_fp);
void GetStringUpper(const char *_mode, char *_outputMode);


#endif
