#!/usr/bin/perl
use strict;
use warnings;

open my $fh, "<", "radio.asx";

my $str;
my $cat_list;
my $idx = 0;
my $p_idx = 0;
my $url_list;
my $first = 0;

$cat_list = <<TEXT;
struct cat_list_s {
	char name[256];
	int start;
	int end;
	};

struct cat_list_s cat_list[] =
{
TEXT


$url_list = <<TEXT;
struct url_list_s {
	char name[256];
	char url[256];
};

struct url_list_s url_list[] =
{
TEXT

foreach (<$fh>) {
	if ($_ =~ /<!-- (.*?) -->/) {
		my $str = $1;
		$str =~ s/이하 //;
		$p_idx = $idx;
		my $t = $idx - 1;

		if ($first == 0) {
			$first = 1;
			$cat_list .= "\t{\"$str\", $p_idx, ";
		}
		else {
			$cat_list .= "$t},\n\t{\"$str\", $p_idx, ";
		}

	}

	if ($_ =~ /<title>(.*?)<\/title>/) {
		my $str = $1;
		$str =~ s/(.*) http.*/$1/;
		$url_list .= "/*$idx*/\t{\"$str\", ";
	}
	if ($_ =~ /<ref href = \"(.*?)\"\/>/) {
		$url_list .= "\"$1\"},\n";
		$idx++;
	}
}
close $fh;

my $t = $idx - 1;
$cat_list .= "$t},\n};\n";
$url_list .= "\n};\n";

open $fh, ">", "radio_list.h";

print $fh $cat_list;
print $fh "\n";
print $fh $url_list;

close $fh;


=pod
while ($str =~ /<entry>(.*?)<\/entry>/g || $str =~ /<!--(.*?)-->/g) {
	my $title;
	my $url;
	my $str = $1;

	print $str, "\n";
}
	if ($str =~ /<title>(.*?)<\/title>/) {
		$title = $1;
	}

	if ($str =~ /<ref href = \"(.*?)\"\/>/) {
		$url = $1;
	}

	print "$title $url\n";
}
=mod

