#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include "radio_list.h"

#define MAXLEN 1024

struct msg_shmem_s
{
	int write_f;
	int index;
	char url[256];
};

struct msg_shmem_s* msg;

int init_shmem()
{
	int msg_shmid;

	msg_shmid = shmget((key_t)5678, sizeof(struct msg_shmem_s), 0666 | IPC_CREAT);

	if (msg_shmid == -1)
	{
		printf("msg_shmid shmget(): %s\n", strerror(errno));
		return -1;
	}

	msg = (struct msg_shmem_s*) shmat(msg_shmid, (void*) 0, 0);
	if (msg == 0)
	{
		printf("msg shmat(): %s\n", strerror(errno));
		return -1;
	}
}

void unencode(char* src, char* last, char* dest)
{
	for (; src != last; src++, dest++)
		if (*src == '+')
			*dest = ' ';
		else if (*src == '%')
		{

			int code;
			if (sscanf(src + 1, "%2x", &code) != 1) code = '?';
			*dest = code;
			src += 2;
		}
		else
			*dest = *src;

	*dest = '\n';
	*++dest = '\0';
}

int main()
{
	int i;
	char cmdline[128];
	int sel;
	char* env_data;
	int cat_index;
	int url_index;
	int ctrl_play = 0;
	int ctrl_stop = 0;
	char* lenstr;
	char input[MAXLEN], data[MAXLEN];
	long len;

	init_shmem();

	printf("Content-Type: text/html;charset=utf-8\n\n");
	printf("<html>\n");
	printf("<head>\n");
	printf("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, target-densitydpi=medium-dpi\" />\n");
	printf("<style type=\"text/css\">\n");
	printf(".bg_image {\n");
	printf("width: 100%%;\n");
	printf("vertical-align: bottom;\n");
	printf("}\n");

	printf("</style>\n");
	printf("</head>\n");
	printf("<script language=\"JavaScript\">\n");
	printf("function move(sel){\n");
	printf("var $index=sel.value;\n");
	printf("location.href=\"i-radio.cgi?cat_index=\"+$index;");
	printf("}\n");

	printf("</script>\n");
	printf("<body>\n");
	printf("<center>\n");

#if 1
	env_data = (char*) getenv("QUERY_STRING");

	cat_index = 0;
	url_index = 0;

	if (env_data != NULL)
	{
		if (sscanf(env_data, "cat_index=%d&url_index=%d", &cat_index, &url_index) != 2)
		{
		}

		if (strcasestr(env_data, "stop")) ctrl_stop = 1;
		if (strcasestr(env_data, "play")) ctrl_play = 1;
	}
#else
	lenstr = (char*) getenv("CONTENT_LENGTH");
	if (lenstr == NULL || sscanf(lenstr, "%ld", &len) != 1 || len > MAXLEN)
	{
		//printf("Error in invocation - wrong FORM probably.");
	}
	else
	{
		fgets(input, len + 1, stdin);
		unencode(input, input + len, data);
		data[len] = 0;

		if (sscanf(data, "cat_index=%d&url_index=%d", &cat_index, &url_index) != 2)
		{
		}

		if (strcasestr(data, "stop")) ctrl_stop = 1;
		if (strcasestr(data, "play")) ctrl_play = 1;
	}
#endif

	//printf("cat_index=%d, url_index: %d,  ctrl_stop=%d, ctrl_play=%d<br>\n", cat_index, url_index, ctrl_stop, ctrl_play);

	printf("<br><br>\n");
	printf("<img src=\"/inter-m_logo.gif\"></img>\n");
	printf("<br><br>\n");
	printf("<form action=\"i-radio.cgi\" method=GET name=\"menuForm\">\n");
	printf("<select name=\"cat_index\" width=\"720\" style=\"width: 360px\" onchange=move(this)>\n");

	for (i = 0; i < sizeof(cat_list) / sizeof(struct cat_list_s); i++)
	{
		if (i == cat_index)
		{
			printf("<option value=\"%d\" selected=\"true\">%s</option>\n", i, cat_list[i].name);
		}
		else
		{
			printf("<option value=\"%d\">%s</option>\n", i, cat_list[i].name);
		}
	}

	printf("</select>\n");
	printf("<br><br>\n");
	printf("<select name=\"url_index\" width=\"720\" style=\"width: 360px\">\n");

	for (i = cat_list[cat_index].start; i <= cat_list[cat_index].end; i++)
	{
		if (i == url_index)
		{
			printf("<option value=\"%d\" selected=\"true\">%s</option>\n", i, url_list[i].name);
		}
		else
		{
			printf("<option value=\"%d\">%s</option>\n", i, url_list[i].name);
		}
	}

	printf("</select>\n");
	printf("<br><br>\n");
	printf("<button style=\"width:120;height:50\" type=\"submit\" value=\"Play\" name=\"control\">Play</button>\n");
	printf("<button style=\"width:120;height:50\" type=\"submit\" value=\"Stop\" name=\"control\">Stop</button>\n");
	printf("</form>\n");

	if(ctrl_stop || ctrl_play)
	{
		if(ctrl_stop == 1) sprintf(msg->url, "stop");
		else
		{
			sprintf(msg->url, "%s", url_list[url_index].url);
		}

		msg->write_f = 1;
		while(1)
		{
			if(msg->write_f == 0) break;
			sleep(1);
		}
	}

	printf("</center>\n");
	printf("</body>\n");
	printf("</html>");
}
