#include <unistd.h> 
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 
#include <sys/types.h> 
#include <sys/ipc.h> 
#include <sys/msg.h> 
#include <errno.h> 

struct msg_shmem_s
{
	int write_f;
	int index;
	char url[256];
};

struct msg_shmem_s *msg;

int init_shmem()
{
	int msg_shmid;

	msg_shmid = shmget((key_t)5678, sizeof(struct msg_shmem_s), 0666 | IPC_CREAT);

	if(msg_shmid == -1)
	{
		printf("msg_shmid shmget(): %s\n", strerror(errno));
		return -1;
	}

	msg = (struct msg_shmem_s *) shmat(msg_shmid, (void*) 0, 0);
	if(msg == 0)
	{
		printf("msg shmat(): %s\n", strerror(errno));
		return -1;
	}
}

int main()
{
	int pid;
	char cmdline[256];
	int mypid;

	init_shmem();

	memset(msg, 0, sizeof(struct msg_shmem_s));

	while(1)  
	{  
		if(msg->write_f == 0)
		{  
			sleep(1);
			continue;
		}  
		msg->write_f = 0;

		///pid = fork();

		//if(pid == 0)
		{
			//mypid = getpid();
			printf("got message: %s\n", msg->url);  
			system("killall -SIGTERM mplayer");
			if(!strncmp(msg->url, "stop", 4))
			{
			}
			else
			{
				sprintf(cmdline, "/opt/interm/bin/listen_to %s", msg->url);
				system(cmdline);
			}
			//exit(0);
		}
	}  

}
