
<?php

include "/opt/interm/www/html/common/common_define.php";

$loadXml                = simplexml_load_file(NETWORK_CONF_XML);
$unicast_mac_addr    	= common_xmlReader($loadXml, XML_NETWORK_MAC_PATH);
$unicast_host_name      = common_xmlReader($loadXml, XML_NETWORK_HOSTNAME_PATH);
$unicast_dhcp           = common_xmlReader($loadXml, XML_NETWORK_DHCP_PATH);
$unicast_ip_addr        = common_xmlReader($loadXml, XML_NETWORK_IP_PATH);
$unicast_subnet_mask    = common_xmlReader($loadXml, XML_NETWORK_NETMASK_PATH);
$unicast_gateway        = common_xmlReader($loadXml, XML_NETWORK_GATEWAY_PATH);
$unicast_dns1_server    = common_xmlReader($loadXml, XML_NETWORK_DNS1_PATH);
$unicast_dns2_server    = common_xmlReader($loadXml, XML_NETWORK_DNS2_PATH);
?>

<html>
	<?include "/opt/interm/www/html/auth_admin/params/header.php" ?>
	<body>
		<table style="padding: 	0; border: 0; border-spacing: 0; height: 100%; vertical-align: top; " border="0" cellpadding="0" cellspacing="0" width="800">
			<tr>
				<td width="800" colspan="3" height="90">
					<?include "/opt/interm/www/html/auth_admin/params/top.php" ?>
				</td>
			</tr>

			<tr>
				<td class="menu_bg_white" width="200" valign="top" style="background-color: #2e312e">
					<?include "/opt/interm/www/html/auth_admin/params/menu.php" ?>
				</td>
				
				<td>
					<table style="padding: 	0; border: 0; border-spacing: 0; height: 100%; vertical-align: top; ">
						<tr>
							<td valign="top">
								<p class="header_font"> <?=NETWORK_SET_STR ?></p>
								
								<form name="mainForm">
									<!-- menu block -->
									<?include "/opt/interm/www/html/auth_admin/params/network/network_macaddr.php" ?>
			
									<!-- client block -->
									<?include "/opt/interm/www/html/auth_admin/params/network/network_hostname.php" ?>
			
									<!-- server block -->
									<?include "/opt/interm/www/html/auth_admin/params/network/network_ipaddr.php" ?>
			
			                        <!-- progress bar block -->
									<?include "/opt/interm/www/html/auth_admin/params/progressBlock.php" ?>
			
									<!-- submit or reset block -->
									
									<table border="0" cellpadding="2" width="615">
										<tr>
											<td width="20"></td> 
											<td align="RIGHT">
												<input type="button" id="<?=BUTTON_SUBMIT_ID ?>" value="<?=SUBMIT_SET_BUTTON ?>" onclick="SubmitForm(this.form)">
												<input type="reset"	 id="<?=BUTTON_RESET_ID ?>" value="<?=SUBMIT_CLEAR_BUTTON ?>" onclick="ResetForm(this.form)">
											</td>
										</tr>
									</table>
								</form>
							</td>
						</tr>
						
						<tr>
							<td valign="bottom" align="center">
								<!-- help & tip -->
								<?=common_displayHelp(SYSTEM_CONNET_VALUE_MSG, NETWORK_HELP1, HOST_NAME_SPACE_MSG, HOST_NAME_ALPA_MSG) ?>
			
								<!-- display copyright block -->
								<?include "/opt/interm/www/html/auth_admin/params/copyright.php" ?>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table> 
	</body>
</html>



<script language="JavaScript">

 	function common_ipSplit(ipAddr) 
 	{
		ip = new Array;
		ip = ipAddr.split('.');
	
		return ip;
	}
	
	function common_checkIpAddr(name, ip) {
		ipAddr = new Array;
		ipAddr = common_ipSplit(ip.value);

		for( var idx = 0 ; idx < 4 ; idx++ ) {
			if( isNaN(ipAddr[idx]) ) {
				ip.focus();
				alert(name + '<?=INVALID_IP_MSG ?>');
				return false;
			}

			if( ipAddr[idx] == "" || isNaN(ipAddr[idx]) || ipAddr[idx] < 0 || ipAddr[idx] > 254 ) {
				ip.focus();
				alert(name + '<?=INVALID_IP_MSG ?>');

				return false;
			}
		}

		return true;
	}
	

function ResetForm(form) {	

	if( ( form.setDhcp.checked == true ) && ( '<?=$unicast_dhcp?>' == '<?=ENABLE_NO?>' ) ) {
		form.setDhcp.checked 	= false;
		form.setStatic.checked 	= true;
		form.ipaddr.disabled 	= false;
		form.subnet.disabled 	= false;
		form.gateway.disabled 	= false;
		form.dns1.disabled 		= false;
		form.dns2.disabled 		= false;
	} else if( ( form.setDhcp.checked == false ) && ('<?=$unicast_dhcp?>' == '<?=ENABLE_YES?>' ) ) {
		form.setDhcp.checked 	= true;
		form.setStatic.checked 	= false;
		form.ipaddr.disabled 	= true;
		form.subnet.disabled 	= true;
		form.gateway.disabled 	= true;
		form.dns1.disabled 		= true;
		form.dns2.disabled 		= true;
	}	
}

function CheckRadioStatic(form, type) {
	if(type == "dhcp")
	{
		form.setDhcp.checked 	= true;
		form.setStatic.checked 	= false;
		form.ipaddr.disabled 	= true;
		form.subnet.disabled 	= true;
		form.gateway.disabled 	= true;
		form.dns1.disabled 		= true;
		form.dns2.disabled 		= true;
	} else {
		form.setDhcp.checked 	= false;
		form.setStatic.checked 	= true;
		form.ipaddr.disabled 	= false;
		form.subnet.disabled 	= false;
		form.gateway.disabled 	= false;
		form.dns1.disabled 		= false;
		form.dns2.disabled 		= false;
	}
}

function SubmitForm(form) {	
	var blank_patten = /[\s]/g;

	if(form.hostname.value == "" || blank_patten.test(form.hostname.value) ) {		
		alert('<?=HOST_NAME_SPACE_MSG?>');
		form.hostname.focus();
		return false;
	}
	var check = /[ㄱ-ㅎ|ㅏ-ㅣ|가-힣]/;
	if(check.test(form.hostname.value)) {
		alert('<?=HOST_NAME_KOREAN_MSG?>');
		form.hostname.focus();
		return false;
	}
	var special_patten = /[`~!@#$%^&*|\\\'\";:?]/gi;
	if(special_patten.test(form.hostname.value)) {
		alert('<?=HOST_NAME_ALPA_MSG?>');
		form.hostname.focus();
		return false;
	}
	
	if( form.setStatic.checked == true ) {
		if( common_checkIpAddr('<?=IP_ADDR_STR ?>', form.ipaddr) == false ) {
			return false;
		}

		if( common_checkIpAddr('<?=GATE_WAY_STR ?>', form.gateway) == false ) {			
			return false;
		}

		if( common_checkIpAddr('<?=DNS_1_STR ?>', form.dns1) == false ) {
			return false;
		}
		
		if( common_checkIpAddr('<?=DNS_2_STR ?>', form.dns2) == false ) {
			return false;
		}		
	}
	if( !confirm('<?=NETWORK_SETTING_MSG ?>') ) {
		return false;
	}
	alert('<?=SYSTEM_RESETUP_MSG ?>');
			
	// loading screen show
	common_viewLoader();
	// progress bar 구현 필요
	
	// hostname
	var submitParams = common_makeParams("hostname", form.hostname.value);
	
	// dhcp or static
	if( form.setDhcp.checked == true ) {
		submitParams += common_makeParams("setDhcp", '<?=VALUE_ON ?>');
		
	} else {
		submitParams += common_makeParams("setStatic", '<?=VALUE_ON ?>');
	}
	
	// ip address
	submitParams += common_makeParams("ipaddr", form.ipaddr.value);

	// subnetmask 
	submitParams += common_makeParams("subnet", form.subnet.value);
	
	// gateway 
	submitParams += common_makeParams("gateway", form.gateway.value);

	// dns1 
	submitParams += common_makeParams("dns1", form.dns1.value);
	
	// dns2 
	submitParams += common_makeParams("dns2", form.dns2.value);
		
	
	new ajax.xhr.Request('<?=AJAX_NETWORK_PATH ?>', submitParams, SubmitedForm, '<?=METHOD_POST ?>');
	
	common_hideLoader(20);
	window.setTimeout(function() {RedirectUrl(form.ipaddr.value); }, 20000);
	
	return true;
}

function RedirectUrl(ipAddr) {
	window.location = "http://" + ipAddr;
}

function SubmitedForm(req) {
	
	/*
	if( req.readyState == <?=READY_STAT_SUCCESS ?> ) {
		if( req.status == <?=STATUS_SUCCESS ?> ) {
		// 완료 알림
		common_hideLoader(20);
			
		} else {
			// 정상이 아닌 case 메시지 출력
			common_notiServerState(req.status);
			common_hideLoader(<?=RESPONSE_ERROR ?>);
		}
	}
	*/
} 
	
	
</script>
