<?php
	include "common/common_define.php";
	
	// radio의 category 및 channel index 호출
	$idxXmls = simplexml_load_file(RADIO_CONF_XML);
	$radio_category_index	= common_xmlReader($idxXmls, RADIO_CATEGORY_INDEX_PATH);
	$radio_channels_index	= common_xmlReader($idxXmls, RADIO_CHANNELS_INDEX_PATH);
	
	// 전체 category 및 channel 호출
	$radioUserXmls   = simplexml_load_file(RADIO_USER_CHANNELS_XML);
	
	$radioPrefix = common_xmlReader($idxXmls, RADIO_CHANNEL_PREFIX_PATH);
	$radioPrefixXmls = simplexml_load_file(RADIO_PREFIX_CHANNELS_XML . "_" . $radioPrefix . ".xml");
?>

<html>
	 <?include "params/header.php" ?>

		<body>
			<table style="padding: 	0; border: 0; border-spacing: 0; height: 100%; vertical-align: top; " border="0" cellpadding="0" cellspacing="0" width="800">
				<tr>
					<td width="800" colspan="3" height="90">
						<?include "params/top.php" ?>
					</td>
				</tr>
				<tr>
					<td class="menu_bg_white" width="200" valign="top" style="background-color: #2e312e">
						<?include "params/menu.php" ?>
					</td>
							
					<td>
						<table style="padding: 	0; border: 0; border-spacing: 0; height: 100%; vertical-align: top; ">
							<tr>
								<td valign="top">
									<p class="header_font"> <?=RADIO_CONN_SETUP ?> </p>
	
									<form name="mainForm">
										<!-- menu block -->
										<?include "params/radio/radio_main.php" ?>
											
										<!-- submit or reset block --> 
										<table border="0" cellpadding="2" width="615">
											<tr>
												<td align="right"> 
													<input type="button" name="radioPlay"  value="<?=RADIO_PLAY_STR ?>" onclick="SubmitForm(this.form, true)" style="width:47px">
													<input type="button" name="radioStop"  value="<?=RADIO_STOP_STR ?>" onclick="SubmitForm(this.form, false)" style="width:47px">
												</td>
											</tr>
											<tr>
												<td align="right"> 
													<input type="button" name="radiouser" value="<?=RADIO_USER_CATEGORY ?>" onclick="PopUpEntryPage();" style="width:99px">
												</td>
											</tr>
										</table>
									</form>
								</td>
							</tr>
							
							<tr>
								<td valign="bottom" align="center">
									<!-- help & tip -->
									<?=common_displayHelp(RADIO_HELP_MSG , RADIO_HELP_PLAY)?>
				
									<!-- display copyright block -->
									<?include "params/copyright.php" ?>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table> 
		</body>
</html>

<script language="JavaScript">

function SubmitForm(form, type) {
	if( form.radio_channels.value == '<?=VALUE_OFF ?>' && type == true ) {
		alert('<?=RADIO_EMTPY_PLAYLIST_STR ?>');
		return false;
	}
	 
	// loading screen show
	common_viewLoader();
	
	var idx = form.radio_channels.selectedIndex;
	var submitParams = common_makeParams("idxCategory", form.radio_category.selectedIndex);
	submitParams 	+= common_makeParams("idxChannels", form.radio_channels.selectedIndex);
	submitParams 	+= common_makeParams("channelUrl",  form.radio_channels.value);
	submitParams 	+= common_makeParams("channelName", form.radio_channels[idx].text);
	
	if( type == false ) {
		// Stop
		submitParams += common_makeParams("radioStop", '<?=VALUE_ON ?>');
		
	} else {
		// Play
		submitParams += common_makeParams("radioPlay", '<?=VALUE_ON ?>');
	}
	new ajax.xhr.Request('<?=AJAX_RADIO_PATH ?>', submitParams, SubmitedForm, '<?=METHOD_POST ?>');
	
}

function PopUpEntryPage(){
	displayWidth = 520;
	displayHeigth = 800;
 	axisX = (screen.availWidth - displayWidth) / 2;
 	axisY = (screen.availHeight - displayHeigth) / 2;
	
	window.open('/params/radio/radio_user.php', 'pop', 'width='+displayWidth+', height='+displayHeigth + ', left='+axisX+'top='+axisY+', resizable=no, scrollbars=yes');
	
	return true;
}

function SubmitedForm(req) {
	if( req.readyState == <?=READY_STAT_SUCCESS ?> ) {
		if( req.status == <?=STATUS_SUCCESS ?> ) {
			// 완료 알림
			var arrResponse = req.responseText.split("\n");
			var radioStat = arrResponse[arrResponse.length - 1].replace(/<(.*?)>/gi,"");
			
			if( radioStat == '<?=RADIO_ERROR_TIMEOUT ?>' ) {
				alert('<?=RADIO_ERROR_TIMEOUT_MSG ?>');
				common_hideLoader(<?=RESPONSE_ERROR ?>);
				
			} else if( radioStat == '<?=RADIO_ERROR_REFUSED ?>' ) {
				alert('<?=RADIO_ERROR_REFUSED_MSG ?>');
				common_hideLoader(<?=RESPONSE_ERROR ?>);
				
			} else if( radioStat == '<?=RADIO_ERROR_VIDEO ?>' ) {
				alert('<?=RADIO_ERROR_VIDEO_MSG ?>');
				common_hideLoader(<?=RESPONSE_ERROR ?>);
				
			} else if( radioStat == '<?=RADIO_ERROR_CLOSED ?>' ) {
				alert('<?=RADIO_ERROR_CLOSED_MSG ?>');
				common_hideLoader(<?=RESPONSE_ERROR ?>);
				
			} else if( radioStat == '<?=RADIO_ERROR_EXITING ?>' ) {
				alert('<?=RADIO_ERROR_EXITING_MSG ?>');
				common_hideLoader(<?=RESPONSE_ERROR ?>);
			
			} else {
				common_hideLoader(<?=RESPONSE_SUCCESS ?>);	
			}
			
		} else {
			// 정상이 아닌 case 메시지 출력
			common_notiServerState(req.status);
			common_hideLoader(<?=RESPONSE_ERROR ?>);
		}
	}
}

</script>