<?php
include "/opt/interm/www/html/common/common_define.php";
$zone_name = array(		"Eniwetok Kwajalein",
 						"MidwayIsland ,Samoa",
 						"Hawaii",
						"Alaska",
						"Pacific Time(US & Canada), Tijuana",
						"Arizona",
						"Mountain Time(US & Canada)",
						"Central Time(US & Canada)",
						"Mexico City, Tegucigalpa",
						"Saskatchewan",
						"Bogota, Lima, Quito",
						"Eastern Time(US &amp; Canada)",
						"Indiana(East)",
						"Atlantic Time(Canada)",
						"Caracas, La Paz",
						"Santiago",
						"Newfoundland",
						"Brasilia",
						"Buenos Aires, Georgetown",
						"Mid-Atlantic",
						"Azores, Cape Verde Is.",
						"Greenwich Mean Time : Dublin, Lisbon, London",
						"Amsterdam, Berlin, Rome, Stockholm, Vienna",
						"Belgrade, Bratislava, Budapest, Ljubljana",
						"Brussels, Copenhagen, Madrid, Paris, Vilnius",
						"Sarajevo, Skopje, Sofija, Warsaw, Zagreb",
						"Athens, Istanbul, Minsk",
						"Bucharest",
  						"Cairo",
						"Harare, Pretoria",
						"Helsinki, Riga, Tallinn",
						"Israel",
						"Baghdad, Kuwait, Riyadh",
						"Moscow, St. Petersburg, Volgograd",
						"Nairobi",
						"Tehran",
						"Abu Dhabi, Muscat",
						"Baku, Tbilisi",
						"Kabul",
						"Yekaterinburg",
						"Islamabad, Karachi, Tashkent",
						"Bombay, Calcutta, Madras, New Delhi",
						"Almaty, Dhaka",
						"Colombo",
						"Bangkok, Hanoi, Jakarta",
						"Beijing, Chongqing, Hong Kong, Urumqi",
						"Perth",
						"Singapore",
						"Taipei",
  						"Osaka, Sapporo, Tokyo",
						"Seoul",
						"Yakutsk",
						"Adelaide",
						"Darwin",
						"Brisbane",
						"Canberra, Melbourne, Sydney",
						"Guam, Port Moresby",
						"Hobart",
						"Vladivostok",		
  						"Magadan, Solomon Is., New Caledonia",
						"Auckland, Wellington");			

$tz_name = array (	"Pacific/Kwajalein",
					"US/Samoa",
					"US/Hawaii",
					"US/Alaska",
					"US/Pacific",
					"US/Arizona",
					"US/Mountain",
					"US/Central",
					"America/Mexico_City",
					"Canada/Saskatchewan",
					"America/Lima",
					"US/Eastern",
					"US/East-Indiana",
					"Canada/Atlantic",
					"America/Caracas",
					"America/Santiago",
					"Canada/Newfoundland",
					"Brazil/East",
					"America/Argentina/Buenos_Aires",
					"Atlantic/South_Georgia",
					"Atlantic/Azores",
					"Europe/London",
					"Europe/Amsterdam",
					"Europe/Belgrade",
					"Europe/Brussels",
					"Europe/Sarajevo",
					"Europe/Athens",
					"Europe/Bucharest",
					"Egypt",
					"Africa/Harare",
					"Europe/Helsinki",
					"Asia/Tel_Aviv",
					"Asia/Baghdad",
					"Europe/Moscow",
					"Africa/Nairobi",
					"Asia/Tehran",
					"Asia/Dubai",
					"Asia/Tbilisi",
					"Asia/Kabul",
					"Asia/Yekaterinburg",
					"Asia/Karachi",
					"Asia/Calcutta",
					"Asia/Almaty",
					"Asia/Colombo",
					"Asia/Bangkok",
					"Asia/Hong_Kong",
					"Australia/Perth",
					"Asia/Singapore",
					"Asia/Taipei",
					"Asia/Tokyo",
					"Asia/Seoul",
					"Asia/Yakutsk",
					"Australia/Adelaide",
					"Australia/Darwin",
					"Australia/Brisbane",
					"Australia/Canberra",
					"Pacific/Port_Moresby",
					"Australia/Hobart",
					"Asia/Vladivostok",
					"Asia/Magadan",
					"Pacific/Auckland");

$loadxml = simplexml_load_file(TIME_CONF_XML);

$time_servert_name 	= common_xmlReader($loadxml, XML_TIME_SER_IP_PATH);
$time_zone_idx 		= common_xmlReader($loadxml, XML_TIME_ZONE_INDEX);
$time_setup 		= common_xmlReader($loadxml, XML_TIME_SER_MODE_PATH);
$time_sync_time 	= common_xmlReader($loadxml, XML_TIME_SYNC_TIME);

if (isset($time_sync_time) == false)
{
	$time_sync_time = 3;
}
	
$today = time();

date_default_timezone_set($tz_name[(int)$time_zone_idx]);

$daylight_time  = date('I');

$manual_year 	= date('Y');
$manual_month	= date('m');
$manual_day		= date('d');
$manual_hour 	= date('H');
$manual_minute 	= date('i');
$manual_second 	= date('s');


?>

<html>
		<?include "/opt/interm/www/html/auth_admin/params/header.php" ?>

		<body onload="Clock()">
			<table style="padding: 	0; border: 0; border-spacing: 0; height: 100%; vertical-align: top; " border="0" cellpadding="0" cellspacing="0" width="800">
				<tr>
					<td width="800" colspan="3" height="90">
						<?include "/opt/interm/www/html/auth_admin/params/top.php" ?>
					</td>
				</tr>
				<tr valign="top">
					<td class="menu_bg_white" width="200" style="background-color: #2e312e">
						<?include "/opt/interm/www/html/auth_admin/params/menu.php" ?>
					</td>
			
					<td>
						<table style="padding: 	0; border: 0; border-spacing: 0;  vertical-align: top; ">
							<tr>
								<td valign="top">
									<p class="header_font"> <?=TIME_DATE ?> </p>
	
									<form name="mainForm">
										<!-- time zone block-->
										<?include "/opt/interm/www/html/auth_admin/params/time/time_timezone.php" ?>
										<!-- current time block -->
										<?include "/opt/interm/www/html/auth_admin/params/time/time_current.php" ?>
										<!-- time setting block -->
										<?include "/opt/interm/www/html/auth_admin/params/time/time_setting.php" ?>

										<!-- submit  block --> 
										<table border="0" cellpadding="2" width="600">
											<tr>
												<td align="RIGHT">
														<input type="button" value="<?=SUBMIT_SET_BUTTON ?>" onclick="SubmitForm(this.form)">
												</td>
											</tr>
										</table>
									</form>
								</td>
							</tr>
							
							<tr>
								<td valign="bottom" align="center">
									<!-- display help&tip block -->
									<?=common_displayHelp(CONNECT_DELAY_MSG, AUTOMATIC_TIME_MSG, TIME_SIBO_MSG) ?>
			
									<!-- display copyright block -->
									<?include "/opt/interm/www/html/auth_admin/params/copyright.php" ?>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table> 
		</body>
</html>

<script language="JavaScript"> 
	var timer;//전역 변수 선언.
	var first = true;
	var g_year = '<?=$manual_year ?>';
	var g_month = '<?=$manual_month ?>';
	var g_day = '<?=$manual_day ?>';
	var g_hour = '<?=$manual_hour ?>';
	var g_minute = '<?=$manual_minute ?>';
	var g_second = '<?=$manual_second ?>';
	var g_dstSet = '<?=$daylight_time ?>';
	var time_mode = '<?=$time_setup ?>';
	
    function Display_Clock(time_str)
    {
        var clock = document.getElementById("clock");         // 출력할 장소 선택
        clock.innerHTML = time_str;         // 현재시간을 출력
    }

// return time value parsing

    function Clock() 
    {
        $.ajax({
            url:"/conf/emitTime.txt",
            type:"POST",
            timeout:1000,
            async: true,
            dataType: "text",
            cache:false,
            success: function(output){
              Display_Clock(output);
              }
        });
        if (timer != 0)
            clearTimeout(timer);
        timer = setTimeout("Clock()", 1000);
    }
	
	function CheckRadioStatic(form, type) {
		if( type == '<?=TYPE_MANUAL ?>' ) {
			form.setManual.checked	= true;
			form.setAuto.checked 	= false;
			form.timeserver.disabled = true;
			form.synctime.disabled  = true;
			form.setYear.disabled 	= false;
			form.setMonth.disabled 	= false;
			form.setDay.disabled 	= false;
			form.setHour.disabled 	= false;
			form.setMinute.disabled = false;
			form.setSecond.disabled = false;
		} else if( type == '<?=TYPE_SERVER ?>' ) {
			form.setManual.checked 	= false;
			form.setAuto.checked 	= true;
			form.timeserver.disabled = false;
			form.synctime.disabled  = false;
			form.setYear.disabled	= true;
			form.setMonth.disabled	= true;
			form.setDay.disabled	= true;
			form.setHour.disabled	= true;
			form.setMinute.disabled = true;
			form.setSecond.disabled = true;
		} else {
			form.setManual.checked 	= false;
			form.setAuto.checked 	= true;
			form.timeserver.disabled = false;
			form.synctime.disabled  = false;
			form.setYear.disabled 	= true;
			form.setMonth.disabled 	= true;
			form.setDay.disabled 	= true;
			form.setHour.disabled 	= true;
			form.setMinute.disabled = true;
			form.setSecond.disabled = true;
		}
	}	
	
	function SubmitForm(form) {		
		// 사용자 설정 부분 체크		
		if( form.setManual.checked )
		{
			// year
			if( form.setYear.value < 1980 ) {
				alert('<?=VALID_YEAR_MSG ?>');
				return false;
			}

			if( form.setYear.value > 2030 ) {
				alert('<?=VALID_YEAR_MSG ?>');
				return false;
			}
			
			// month
			if( (form.setMonth.value < 1) || (form.setMonth.value > 12) ) {
				alert('<?=VALID_MONTH_MSG ?>');
				return false;
			}
			
			// day
			if( (form.setDay.value < 1) || (form.setDay.value > 31) ) {
				alert('<?=VALID_DAY_MSG ?>');
				return false;
			}
			
			// hour
			if( (form.setHour.value < 0) || (form.setHour.value > 23) ) {
				alert('<?=VALID_HOUR_MSG ?>');
				return false;
			}
					
			// minute
			if( (form.setMinute.value < 0) || (form.setMinute.value > 59) ) {
				alert('<?=VALID_MIN_MSG ?>');
				return false;
			}
			
			// second
			if( (form.setSecond.value < 0) || (form.setSecond.value > 59) ) {
				alert('<?=VALID_SEC_MSG ?>');
				return false;
			}													
		}
		
		if( !confirm('<?=TIME_SETTING_MSG ?>') ) {
			return false;
			
		}
		alert('<?=VALID_SET_BUTTON_MSG ?>');
		
		// loading screen show
		common_viewLoader();
		
		// timezone
		var submitParams = common_makeParams("timezone", form.timezone.value);
		
		// audo or static
		if( form.setAuto.checked == true ) {
			submitParams += common_makeParams("setAuto", '<?=VALUE_ON ?>');
			time_mode = 'server';
			
		} else {
			submitParams += common_makeParams("setManual", '<?=VALUE_ON ?>');
			time_mode = 'manual';
		}
		
		// timeserver
		submitParams += common_makeParams("timeserver", form.timeserver.value);
		
		// setHour 
		submitParams += common_makeParams("setHour", form.setHour.value);
		
		// setMinute 
		submitParams += common_makeParams("setMinute", form.setMinute.value);
	
		// setSecond 
		submitParams += common_makeParams("setSecond", form.setSecond.value);
		
		// setMonth 
		submitParams += common_makeParams("setMonth", form.setMonth.value);
			
		// setDay 
		submitParams += common_makeParams("setDay", form.setDay.value);
		
		// setYear 
		submitParams += common_makeParams("setYear", form.setYear.value);
		
		// sync time
		submitParams += common_makeParams("synctime", form.synctime.value);
		
		clearTimeout(timer);
		timer = 0;
		new ajax.xhr.Request('<?=AJAX_TIME_PATH ?>', submitParams, SubmitedForm, '<?=METHOD_POST ?>');
		
		return true;		
	}
	
	function ServerTime(req)
	{
		if( req.readyState == <?=READY_STAT_SUCCESS ?> ) 
		{
			if( req.status == <?=STATUS_SUCCESS ?> ) 
			{
				// 완료 알림
				
				var arrResponse = req.responseText.split("\n");
				var responseText = arrResponse[arrResponse.length - 1].replace(/<(.*?)>/gi,"");
				
				var len = responseText.length;
				var first_pos = responseText.search("stime");
				var second_pos = responseText.search("etime");
				var getstr = responseText.substring(first_pos+5,second_pos);
				var time_array = getstr.split(",");
				
				if( '<?=$document_language ?>' == '<?=LANG_KOR ?>' )
				{	// 한국 시간 표시
					if (time_array[6] == 1)
						dateval = time_array[0] + "." + time_array[1] + "." + time_array[2] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5] + "    DST On";
					else
						dateval = time_array[0] + "." + time_array[1] + "." + time_array[2] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
				}
				else
				{	// 영문식 시간 표시 dd.mm.yy
					if (time_array[6] == 1)
						dateval = time_array[2] + "." + time_array[1] + "." + time_array[0] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5] + "    DST On"; 
					else
						dateval = time_array[2] + "." + time_array[1] + "." + time_array[0] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
				}			
				Display_Clock(dateval);
				timer = setTimeout("Clock()", 1000);
			}
		}	
	}
	
	function SubmitedForm(req) 
	{
		if( req.readyState == <?=READY_STAT_SUCCESS ?> ) 
		{
			if( req.status == <?=STATUS_SUCCESS ?> ) 
			{
			// 완료 알림
				if (timer == 0)
					timer = setTimeout("Clock()", 1000);	
				common_hideLoader(<?=RESPONSE_ERROR ?>);
			}
		}
	}
</script>


