<?php	
	include "/opt/interm/www/html/common/common_define.php";
	
	$error = "";
	$msg = "";
	$fileElementName = 'fileName';
	
	if(!empty($_FILES[$fileElementName]['error'])) {
		switch($_FILES[$fileElementName]['error']) {

			case '1':
				$error = 'The uploaded file exceeds the upload_max_filesize directive in php.ini';
				break;
			case '2':
				$error = 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form';
				break;
			case '3':
				$error = 'The uploaded file was only partially uploaded';
				break;
			case '4':
				$error = 'No file was uploaded.';
				break;
			case '6':
				$error = 'Missing a temporary folder';
				break;
			case '7':
				$error = 'Failed to write file to disk';
				break;
			case '8':
				$error = 'File upload stopped by extension';
				break;
			case '999':
			default:
				$error = 'No error code avaiable';
		}
	}
	else if(empty($_FILES['fileName']['tmp_name']) || $_FILES['fileName']['tmp_name'] == 'none') {
		$error = 'No file was uploaded..'; 
	}
	else 
	{
		$uploadfile = MP3_PATH .$_FILES['fileName']['name'];
		move_uploaded_file( $_FILES['fileName']['tmp_name'] , $uploadfile);
		
		$loadxml = simplexml_load_file($uploadfile);
		if ($loadxml != "")
		{
			$sibo_max = common_xmlReader($loadxml, XML_SIBO_MAX);
			if ($sibo_max >= 0)
			{
				rename($uploadfile, SIBO_CONF_XML);
				common_logWrite(SIBO_FILE_UPLOAD_STR);			
				$msg .= $uploadfile;
				$sibo_use = common_xmlReader($loadxml, XML_SIBO_USE);										
				if (strcmp($sibo_use,"true") == 0)
				{
					common_KillSchedule();
					common_restartSibo();
					unlink($uploadfile);
				}
				else 
				{
					common_KillSchedule();
					unlink($uploadfile);
				}
			}
			else
			{
				unlink($uploadfile);
				$error = "info file error";
			}
		}
		else
		{
			unlink($uploadfile);
			$error = "xml header error";			
		}
	}		
	
	if( $error != "" ) {
		common_logWrite(SIBO_FILE_UPLOAD_FAIL_STR . " - " . $error);
	}
// 이부분이 없으면 넘어가지 않음	
	echo "{";
	echo				"error: '" . $error . "',\n";
	echo				"msg: '" . $msg . "'\n";
	echo "}";	
?>
