<?php

/* 
 * schedule command xml 생성
 * 
 *  argument 1 : schedule index
 *  argument 2 : start(1) or stop(0) 
 *	 
 *  
 */

	error_reporting(E_ALL);
	
	function common_xmlReader($xmls, $nodePath) 
	{
		if ($xmls == "")
			return 0;
		$nodeExists = $xmls -> xpath($nodePath);
		return $nodeExists[0];
	};
 
	function common_logWrite($message) 
	{
		$cmd = '/opt/interm/bin/rlog -f /opt/interm/www/html/log/interm_log.dat -w "'.$message.'" 2>&1 ';
		shell_exec($cmd);	
	};
	
	function common_xmlReader_node($xml, $nodePath)
	{
		if ($xml == "")
			return 0;
		$nodeExists = $xml -> xpath($nodePath);
		return $nodeExists;
	};	
 	
	
/*
 *  TCP/IP data send
 * 
 *  - data	= file path[128]
 */	
	function Send_Command($command_file)
	{
		$address = "127.0.0.1";
		$port = 7074;
		
		$socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
		$text_len = strlen($command_file);
		if ($socket == FALSE)
		{
			return; 	
		}
		
		$cmd = dechex(1);
		$delimit = ",";
		 
		$data_buf = $cmd.$delimit.$command_file;
		socket_sendto($socket, $data_buf, strlen($data_buf), MSG_DONTROUTE, $address, $port);
		
		socket_close($socket);
		
	};
	
	$schedule_idx = $argv[1];	// schedule index
	$schedule_start = $argv[2];	// 1 - start 0 - stop
	
	if ($schedule_start == 0)	// stop
	{
		$fileName_off = sprintf('/opt/interm/www/html/conf/schedule/schedule_%04d_off.xml', (int)$schedule_idx);
		Send_Command($fileName_off);
		return;
	}

	$sch_xml = simplexml_load_file("/opt/interm/www/html/conf/info_schedule.xml");
	$sch_node = common_xmlReader_node($sch_xml, "/config/time_signal");
	
// file info 
	$filenames = Array();
	$file_cnt = count($sch_node[$schedule_idx]->source->filename);
	for ($idx = 0; $idx < $file_cnt; $idx++)
	{
		$filenames[$idx] = "/opt/interm/www/html/mp3/schedule/".$sch_node[$schedule_idx]->source->filename[$idx];
	}
	
	$repeat = $sch_node[$schedule_idx]->time_option;	// 0 - once 1-repeat
	$src_type = $sch_node[$schedule_idx]->source->type;
	$device_id = $sch_node[$schedule_idx]->target->device->id;	// id
	$device_ch = $sch_node[$schedule_idx]->target->device->ch;	// channel
	$volume = $sch_node[$schedule_idx]->target->volume;
// file remove	
	$fileName_on = sprintf('/opt/interm/www/html/conf/schedule/schedule_%04d_on.xml', (int)$schedule_idx);
	$fileName_off = sprintf('/opt/interm/www/html/conf/schedule/schedule_%04d_off.xml', (int)$schedule_idx);
	if (file_exists($fileName_on))
		unlink($fileName_on);
	if (file_exists($fileName_off))
		unlink($fileName_off);
// on part	
// command xml create		
	$dom = new DOMDocument('1.0','UTF-8');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$root = $dom->createElement('config');
	$root->appendChild($dom->createElement('event_type','schedule'));

// zone on	
	$action_main = $dom->createElement('action');
	$action_main->appendChild($dom->createElement('action_type','zone_control'));
	$action_main->appendChild($dom->createElement('label','zone on'));
	$action_main->appendChild($dom->createElement('command','on'));
	
	$action_device = $dom->createElement('device');
	$action_device->appendChild($dom->createElement('id',$device_id));
	$action_device->appendChild($dom->createElement('ch', $device_ch));
	$action_main->appendChild($action_device);
	
	$action_main->appendChild($dom->createElement('volume',$volume));
	$root->appendChild($action_main);
	$dom->appendChild($root);
	
	if ($src_type == "file")
	{
	// mp3 command
		$action_main = $dom->createElement('action');
		$action_main->appendChild($dom->createElement('action_type','mp3'));
		$action_main->appendChild($dom->createElement('label','play'));
		$action_main->appendChild($dom->createElement('command','play'));
		if ($repeat == 0)
			$action_main->appendChild($dom->createElement('repeat_mode','once'));
		else
			$action_main->appendChild($dom->createElement('repeat_mode','repeatall'));
		for ($i = 0; $i < $file_cnt; $i++)
		{
			$action_main->appendChild($dom->createElement('filename',$filenames[$i]));
			$root->appendChild($action_main);
		}	 
	}
	$dom->appendChild($root);
	$dom->save($fileName_on);
	unset($dom);
// off part	
// command xml create		
	$dom = new DOMDocument('1.0','UTF-8');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$root = $dom->createElement('config');
	$root->appendChild($dom->createElement('event_type','schedule'));
// zone off	
	$action_main = $dom->createElement('action');
	$action_main->appendChild($dom->createElement('action_type','zone_control'));
	$action_main->appendChild($dom->createElement('label','zone off'));
	$action_main->appendChild($dom->createElement('command','off'));
	
	$action_device = $dom->createElement('device');
	$action_device->appendChild($dom->createElement('id',$device_id));
	$action_device->appendChild($dom->createElement('ch', $device_ch));
	$action_main->appendChild($action_device);
	
	$action_main->appendChild($dom->createElement('volume',$volume));
	
	$root->appendChild($action_main);
	$dom->appendChild($root);
	
	if ($src_type == "file")
	{
// mp3 command
		$action_main = $dom->createElement('action');
		$action_main->appendChild($dom->createElement('action_type','mp3'));
		$action_main->appendChild($dom->createElement('label','stop'));
		$action_main->appendChild($dom->createElement('command','stop'));
		$action_main->appendChild($dom->createElement('repeat_mode',''));
		$action_main->appendChild($dom->createElement('filename',''));
	}
	$root->appendChild($action_main);
	$dom->appendChild($root);
	$dom->save($fileName_off);
	unset($dom);
	Send_Command($fileName_on);
	unset($filenames);
?>
