#!/usr/bin/perl
#use strict;
#use warnings;

my %in;

print "Content-type: text/html\n\n";

if (length ($ENV{'QUERY_STRING'}) > 0) {
	my $buffer = $ENV{'QUERY_STRING'};
	my @pairs = split /&/, $buffer;
	foreach my $pair (@pairs){
		(my $name, my $value) = split /=/, $pair;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$in{$name} = $value;
	}
}

print "<html>";
my $volume = $in{'volume'};
my $volume_p = $volume * 100 / 192;

if ($volume) {
	if ($volume < 0 || $volume > 192) {
		print "Invalid Range<br>";
	}
	else {
		#print "Set volume to $volume [$volume_p%]";
		qx!su -c "amixer sset 'Playback' $volume"!;
	}		
}

my $current_vol = qx!su -c "amixer sget 'Playback' | grep 'Front Left:'"!;
$current_vol =~ s/.*Front Left: (.*)/$1/g;

print <<endtext;
Volume: $current_vol
<form action="volumectrl.pl">
<label>Input Volume 0 ~ 192 <input name="volume" size="5"></label>
<input type="submit" value="Set">
</form>
</html>
endtext
