<?php
$dayofWeek = array("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT");
$sibo_name = array();
$time_option = array();
$time_min = array();
$time_hour = array();
$time_start = array();
$time_end = array();
$time_week = array();
$temp_hour = array();
$time_file = array();

$file_name = array();
$file_exist = array();

$loadxml = simplexml_load_file(SIBO_CONF_XML);

$signal_node = common_xmlReader_node($loadxml, "/config/time_signal");

$signal_count = count($signal_node);


$sibo_Max = common_xmlReader($loadxml, XML_SIBO_MAX);

if ($signal_count != (int)$sibo_Max)
{
	echo "max value is not equal!\n";
}

for ($idx=0; $idx < $signal_count; $idx++)
{
	$sibo_name[$idx] = $signal_node[$idx]->name;
	$time_option[$idx] = $signal_node[$idx]->time_option;
	$time_min[$idx] =  $signal_node[$idx]->option_min;
	$time_hour[$idx] = $signal_node[$idx]->hour;
	$time_start[$idx] = $signal_node[$idx]->time_start;
	$time_end[$idx] = $signal_node[$idx]->time_end;
	$time_week[$idx] = $signal_node[$idx]->week;
		
	$file_count = count($signal_node[$idx]->source->filename);
	$file_exist[$idx] = 1;
	
	for ($i=0; $i < $file_count; $i++)
	{
		$time_file[$idx][$i] = $signal_node[$idx]->source->filename[$i];
		// file check
		$path = MP3_PATH.$time_file[$idx][$i];
		$handle = fopen($path, "r");
		if ($handle == 0)
		{
			$file_exist[$idx] = 0;
		}
		fclose($handle);	
		$file_name[$idx] = $file_name[$idx].'['.$time_file[$idx][$i].']&#13;&#10;';
	}				
}

function DisplayTitleTdForm($idx,$num)
{
    if ($num == 0)
    {
        $hour = sprintf("%02d", $idx);
	   echo '<td>'.$hour.'</td>';
    }
    else
    {
        echo '<td>'.$idx.'</td>';
    }
};

function DisplayTdForm($idx,$end) 
{
	if ($end == '1'){
		echo '<td style="color: #1f8;font-size:10px;word-wrap:break-word;">'.$idx.'</td>';
	}
	else {
		echo '<td style="color: #1f8;font-size:10px;word-wrap:break-word;">'.$idx.'</td>';
	}
};

function isSetHour($str, $hour)
{
	$re = substr($str, $hour, 1);
	if ($re == "0")
	{
		return false;
	}
	else 
	{
		return true;
	}
};

function confirmTime($start,$end){

	for ($i = 0; $i < 24; $i++)
		$temp_hour[$i] = "FF";
	$part_s = explode(":", $start);
	$num = (int)$part_s[0];
	$temp_hour[$num] = $part_s[1];
	$part_e = explode(":", $end);
	$num = (int)$part_e[0];
	if ($temp_hour[$num] != "FF")
	{
		$temp_hour[$num] = $part_e[1];
	}
	$s = (int)$part_s[0];
	$e = (int)$part_e[0];
	if (($e - $s) > 1)
	{
		for ($i = $s+1; $i < ($e-1); $i++)
		{
			$temp_hour[$i] = "**";	
		}
	}  
};

?>

<table border="1" cellspacing="0" style="width: 100%;font-family:sans-serif;">
    <thead>
        <tr>
            <td colspan=4>&nbsp;</td>
            <td colspan=24><?=SIBO_CENTER_STR2?></td>
            <td colspan=7><?=SIBO_CENTER_STR3?></td>
        </tr>
        <tr>
            <td colspan=3 ><?=SIBO_CENTER_STR4?></td>
            <td><?=SIBO_CENTER_STR5?></td>
            <?php
                for ($idx = 0; $idx < 24; $idx++) 
                {
                    DisplayTitleTdForm($idx,0);
                }
                DisplayTitleTdForm(SIBO_CENTER_STR6,1);
                DisplayTitleTdForm(SIBO_CENTER_STR7,1);
                DisplayTitleTdForm(SIBO_CENTER_STR8,1);
                DisplayTitleTdForm(SIBO_CENTER_STR9,1);
                DisplayTitleTdForm(SIBO_CENTER_STR10,1);
                DisplayTitleTdForm(SIBO_CENTER_STR11,1);
                DisplayTitleTdForm(SIBO_CENTER_STR12,1);
//              for ($idx = 0; $idx < 7; $idx++) {
//                  DisplayTitleTdForm($dayofWeek[$idx],1);
//              }
            ?>
        </tr>
    </thead>
    <tbody>
        <?php
            $em = "&nbsp;";
            for ($i = 0; $i < $sibo_Max; $i++)
            {
                echo '<tr>';
                if ($file_exist[$i] == 1)
                    echo '<td colspan=3>'.$sibo_name[$i].'</td>';
                else
                    echo '<td colspan=3 style="color: red;">'.$sibo_name[$i].'</td>';   
                
                echo '<td><span><a href="#" rel="'.$file_name[$i].'" title="'.$file_name[$i].'"><img src="./params/timeSignal/img/file_icon.png" width="22" border="0"></a></span></td>';
//              echo '<td><span><a href="#" class="tooltip" rel="'.$file_name[$i].'" title="'.$file_name[$i].'"><img src="./params/timeSignal/img/file_icon.png" width="22" border="0"></a></span></td>';

                confirmTime($time_start[$i], $time_end[$i]);
                
                $part_s = explode(":", $time_start[$i]);
                $part_e = explode(":", $time_end[$i]);
                
                for ($idx = 0; $idx < 24; $idx++) 
                {
                    if ($time_option[$i] == 0)
                    {
                        if (isSetHour($time_hour[$i], $idx))
                        {
                            DisplayTdForm($time_min[$i],'0');
                        }
                        else 
                        {
                            DisplayTdForm($em.$em,'0');
                        }
                    }
                    else if ($time_option[$i] == 1)
                    {
                        if ($idx == (int)$part_s[0])
                        {
                            if ((int)$part_s[0] == (int)$part_e[0])
                            {
                                DisplayTdForm($part_s[1].' '.$part_e[1],'0');   
                            }
                            else
                            {
                                DisplayTdForm($part_s[1],'0');      
                            }
                            
                        }
                        else if ($idx == (int)$part_e[0])
                        {
                            DisplayTdForm($part_e[1],'1');
                        }
                        else if (($idx > (int)$part_s[0]) && ($idx < (int)$part_e[0]))
                        {
                            DisplayTdForm("▶",'0');
                        }
                        else
                        {
                            DisplayTdForm($em.$em,'0');
                        }
                    }
                }
                
                for ($idx = 0; $idx < 7; $idx++) 
                {
                    if (isSetHour($time_week[$i], $idx))
                    {
                        DisplayTitleTdForm("●",1);  
                    }
                    else 
                    {
                        DisplayTitleTdForm($em.$em,1);
                    }
                }           
                echo '</tr>';   
            }
        ?>
    </tbody>
    <tfoot>
        <tr></tr>
    </tfoot>
</table>
