<?php
	include "/opt/interm/www/html/common/common_define.php";
	
	$copyright_homeLink = "http://www.inter-m.com";

$tz_name = array (	"Pacific/Kwajalein",
					"US/Samoa",
					"US/Hawaii",
					"US/Alaska",
					"US/Pacific",
					"US/Arizona",
					"US/Mountain",
					"US/Central",
					"America/Mexico_City",
					"Canada/Saskatchewan",
					"America/Lima",
					"US/Eastern",
					"US/East-Indiana",
					"Canada/Atlantic",
					"America/Caracas",
					"America/Santiago",
					"Canada/Newfoundland",
					"Brazil/East",
					"America/Argentina/Buenos_Aires",
					"Atlantic/South_Georgia",
					"Atlantic/Azores",
					"Europe/London",
					"Europe/Amsterdam",
					"Europe/Belgrade",
					"Europe/Brussels",
					"Europe/Sarajevo",
					"Europe/Athens",
					"Europe/Bucharest",
					"Africa/Cairo",
					"Africa/Harare",
					"Europe/Helsinki",
					"Asia/Tel_Aviv",
					"Asia/Baghdad",
					"Europe/Moscow",
					"Africa/Nairobi",
					"Asia/Tehran",
					"Asia/Dubai",
					"Asia/Tbilisi",
					"Asia/Kabul",
					"Asia/Yekaterinburg",
					"Asia/Karachi",
					"Asia/Calcutta",
					"Asia/Almaty",
					"Asia/Colombo",
					"Asia/Bangkok",
					"Asia/Hong_Kong",
					"Australia/Perth",
					"Asia/Singapore",
					"Asia/Taipei",
					"Asia/Tokyo",
					"Asia/Seoul",
					"Asia/Yakutsk",
					"Australia/Adelaide",
					"Australia/Darwin",
					"Australia/Brisbane",
					"Australia/Canberra",
					"Pacific/Port_Moresby",
					"Australia/Hobart",
					"Asia/Vladivostok",
					"Asia/Magadan",
					"Pacific/Auckland");	
						
	$xmls = simplexml_load_file(SIBO_CONF_XML);
	$sibo_Max = common_xmlReader($xmls, XML_SIBO_MAX);
	
	$loadxml = simplexml_load_file(TIME_CONF_XML);
	
	$time_zone_idx = common_xmlReader($loadxml, XML_TIME_ZONE_INDEX);
	
	date_default_timezone_set($tz_name[(int)$time_zone_idx]);
	$today = time(); 

	$daylight_time  = date('I');
	$manual_year 	= date('Y');
	$manual_month	= date('m');
	$manual_day		= date('d');
	$manual_hour 	= date('H');
	$manual_minute 	= date('i');
	$manual_second 	= date('s');
	$duplicate_sibo = 0;
?>

<html>
 	<?include "/opt/interm/www/html/auth_clock/params/headerForCal.php" ?>
<body onload="Clock();" onUnLoad="CloseTimer()">
	<table  style="width: 100%;background-color:#262b38;"> 
		<tr>
			<td class="header_font" style="color: #f6eafe;"> <?=SIBO_MOD ?></td>
		</tr>
	</table>
	<table>
		<tr style="height: 5px;"><td></td>
		</tr>
	</table>	
	<form name="mainForm">
	<?include "/opt/interm/www/html/auth_clock/params/timeSignal/mod_select.php" ?>		
	<table>
		<tr style="height: 5px;">
		</tr>
	</table>		
	<?include "/opt/interm/www/html/auth_clock/params/timeSignal/sibo_name.php" ?>
	<table>
		<tr style="height: 5px;">
		</tr>
	</table>	
	<?include "/opt/interm/www/html/auth_clock/params/timeSignal/sibo_files.php" ?>
	<table>
		<tr style="height: 5px;">
		</tr>
	</table>
	<?include "/opt/interm/www/html/auth_clock/params/timeSignal/sibo_time.php" ?>
	<table>
		<tr style="height: 5px;">
		</tr>
	</table>	
	<?include "/opt/interm/www/html/auth_clock/params/timeSignal/sibo_week.php" ?>

	<table border="0" cellpadding="2" style="width: 100%;">
		<tr style="height: 5px;">
		</tr>	
		<tr>
			<td style="width: 5px;"></td> 
			<td style="text-align: right ;">
				<input type="button" id="resetButton" value="<?=SUBMIT_CLEAR_BUTTON?>" onClick="ResetForm(this.form)">
				<input type="button" id="submitButton" value="<?=RM_APPLY?>" onClick="SubmitForm(this.form)">
			</td>
		</tr>
	</table>
		
	</form>
	<table>
		<tr style="height: 5px;">
		</tr>
	</table>
	<table border="0" cellpadding="2" style="width: 100%;">
		<tr>
			<td class="td_copyright_font">
				<center>
					Copyright (c) 2012 <b><a href=<?=$copyright_homeLink ?> target="_new">Inter-M</a></b> All rights reserved.
				</center>
			</td>
		</tr>
	</table>

</body>

</html>

<script language="JavaScript">

	var listSelect = -1; 
	var setApply  = false;
	var time_mode = 0;
	var first = true;
	var timer = null;//전역 변수 선언.
	var g_year = '<?=$manual_year ?>';
	var g_month = '<?=$manual_month ?>';
	var g_day = '<?=$manual_day ?>';
	var g_hour = '<?=$manual_hour ?>';
	var g_minute = '<?=$manual_minute ?>';
	var g_second = '<?=$manual_second ?>';
	var g_dstSet = '<?=$daylight_time ?>';
	
	function common_smallviewLoader(){
		document.body.focus();
		$('#smallviewLoading').fadeIn(400);
		$("#smallviewBackground").css('opacity','0.3').fadeIn(400);
	}	
	function common_smallhideLoader(setTime) {
		if( setTime == <?=RESPONSE_SUCCESS ?> ) {
			$('#smallviewLoading').fadeOut(400);
			$('#smallviewBackground').fadeOut(400);
			setTimeout ("", 400);

		} else if( setTime == <?=RESPONSE_ERROR ?> ) {
			$('#smallviewLoading').fadeOut(400);
			$('#smallviewBackground').fadeOut(400);
			
		} else {
			var num = 0;
			var inputbox = document.getElementById("smallpercentView");
			inputbox.innerHTML = "<table><tr><td height=30><p class=td_menu_font>loading... " + num + "% </p></td></tr></table>";

			$('#smallpercentView').fadeIn(400);
			
			setTime *= 1000;
			var max = 100;
			var interval = setInterval(function() {
							   	num += 1;
							    inputbox.innerHTML = "<table><tr><td height=30><p class=td_menu_font>loading... " + num + "% </p></td></tr></table>";
							    if(num >= max) clearInterval(interval);
							}, (setTime - 1200) / max);

			setTimeout ("$('#smallviewLoading').fadeOut(400)", setTime);
			setTimeout ("$('#smallviewBackground').fadeOut(400)", setTime);
			setTimeout ("$('#smallpercentView').fadeOut(400)", setTime);

			setTimeout ("", setTime + 400);
		}
	}		
   function Clock() 
    {
        $.ajax({
            url:"/conf/emitTime.txt",
            type:"POST",
            timeout:1000,
            async: true,
            dataType: "text",
            cache:false,
            success: function(output){
              Display_Clock(output);
              }
        });
        if (timer != 0)
            clearTimeout(timer);
        timer = setTimeout("Clock()", 1000);
    }
    
    function Display_Clock(time_str)
    {
        var clock = document.getElementById("clock");         // 출력할 장소 선택
        clock.innerHTML = time_str;         // 현재시간을 출력
    }
            
    function CloseTimer()
    {
        clearTimeout(timer);
        timer = 0;  
    }

function update_list()
{
	var sel_list = document.getElementById("select_list");
	for ( var j = 0, l = sel_list.options.length, o; j < l; j++ )
	{
  		o = sel_list.options[j];
  		if (o.selected)
  		{
  			listSelect = j;
  			break;
  		}
  	}
	if (listSelect == -1)
		return false;  	
  	setApply = false;
  	var submitParams = common_makeParams('sel_idx', listSelect);
	common_smallviewLoader();
	new ajax.xhr.Request('/auth_clock/params/timeSignal/sibo_mod_process.php', submitParams, SubmitedForm, 'POST');
}


function AMClick(form)
{
	var idx;
	for (idx = 0; idx < 12; idx++ ) 
	{
		if (form.am.checked == false)
			form.u_hour[idx].checked = false;
		else
			form.u_hour[idx].checked = true;	
	}	
}

function PMClick(form)
{
	var idx;
	for (idx = 12; idx < 24; idx++ ) 
	{
		if (form.pm.checked == false)
			form.u_hour[idx].checked = false;
		else
			form.u_hour[idx].checked = true;	
	}		
}

function allCheckWeek(form)
{
	var idx;
	var length;
	
	for (idx = 0, length = form.week.length ; idx < length ; idx++ ) 
	{
		if (idx < 7)
		{
			if (form.week[7].checked == false)
				form.week[idx].checked = false;
			else
				form.week[idx].checked = true;	
		}
	}
}

function Check_use(form)
{
	var el = document.getElementById("select_time");
	if (el.value == 12)
		document.getElementById("user_part").style.visibility = "visible";
	else
		document.getElementById("user_part").style.visibility = "hidden";
}


function CheckTimePartOnce()
{
	if (document.getElementById("once").checked == true)
	{
		var s_hour = document.getElementById("start_hour").value;
		var s_min = document.getElementById("start_min").value;
		var e_hour = document.getElementById("end_hour").value;
		var e_min = document.getElementById("end_min").value;
		var start = new Date(2000,1,1,s_hour,s_min,0);
		var end = new Date(2000,1,1,e_hour,e_min,0);
		if ((end.getTime() - start.getTime()) <= 0)
		{
			alert('<?=SIBO_TIME_CHECK_MSG ?>');
			return false;
		} 
	}
	return true;
}

function CheckTimeStatic(type,form)
{
	if (type == 'always')
	{
		document.getElementById("always").checked = true;
 		document.getElementById("once").checked = false;
		document.getElementById("select_time").disabled = false;
		if (document.getElementById("select_time").value == 12)
		{
			document.getElementById("user_part").style.visibility = "visible";
		}
		else
		{
			document.getElementById("user_part").style.visibility = "hidden";
		}
		for (idx = 0; idx < 24; idx++ ) 
		{
			form.u_hour[idx].disabled = false;	
		}	
		form.am.disabled = false;
		form.pm.disabled = false;
		form.start_hour.disabled = true;
		form.start_min.disabled = true;
		form.end_hour.disabled = true;
		form.end_min.disabled = true;
	}
	else 
	{
		document.getElementById("always").checked = false;
 		document.getElementById("once").checked = true;
		document.getElementById("select_time").disabled = true;
		document.getElementById("user_part").style.visibility = "hidden";
		for (idx = 0; idx < 24; idx++ ) 
		{
			form.u_hour[idx].disabled = true;	
		}	
		form.am.disabled = true;
		form.pm.disabled = true;
		form.start_hour.disabled = false;
		form.start_min.disabled = false;
		form.end_hour.disabled = false;
		form.end_min.disabled = false;
	}
}

function ResetForm(form) {	
	var index;	
	document.getElementById("s_name").value = "";
	document.getElementById("user_time").value = "";
	var select = document.getElementById("select_file");
	var l;
	for ( var i = 0, l = select.options.length, o; i < l; i++ )
	{
  		o = select.options[i];
  		o.selected = false;
 	}
 	document.getElementById("select_time").value = 0;
 	document.getElementById("always").checked = true;
 	document.getElementById("once").checked = false;
 	document.getElementById("select_time").disabled = false;
	document.getElementById("user_part").style.visibility = "hidden";
	for (idx = 0; idx < 24; idx++ ) 
	{
		form.u_hour[idx].checked = false;	
		form.u_hour[idx].disabled = false;
	}	
	form.am.checked = false;
	form.pm.checked = false;
	
	document.getElementById("start_hour").value = ""; 	
	document.getElementById("start_min").value = ""; 	
	document.getElementById("end_hour").value = ""; 	
	document.getElementById("end_min").value = "";
	
	document.getElementById("start_hour").disabled = true; 	
	document.getElementById("start_min").disabled = true; 	
	document.getElementById("end_hour").disabled = true; 	
	document.getElementById("end_min").disabled = true; 	
	
	for (var idx = 0, length = form.week.length ; idx < length ; idx++ ) 
	{
		form.week[idx].checked = false;
   	}
 
}

function SubmitForm(form) 
{
	var num = 0;
	var name = document.getElementById('s_name').value;
	if (name == "")
	{
		alert('<?=SIBO_ADD_TITLE_ERROR ?>');
		return false;
	}
	var l;
	var select_cnt = 0;
	var select = document.getElementById("select_file");
	var bSelectedFile = 0;
	for ( var j = 0, l = select.options.length, o; j < l; j++ )
	{
  		o = select.options[j];
  		if (o.selected)
  		{
  			bSelectedFile = 1;
  			select_cnt++;
  		}
  	}	
    if (select_cnt > 10)
    {
        alert('<?=SIBO_MAX_FILE?>');
        return false;
    }  	
	if (bSelectedFile == 0)
	{
		alert('<?=SELECT_FILE_MSG?>');
		return false;
	}
		
	var applyhour_str = "";
	if (form.always.checked == true)
	{	
		var bFirst = true;
		for (idx = 0; idx < 24; idx++ ) 
		{
			if (form.u_hour[idx].checked == true)
			{
				if (bFirst == true)
				{
					bFirst = false;
					applyhour_str = idx;
				}
				else
				{
					applyhour_str += ","
					applyhour_str += idx;
				}
			}	
		}	
		if (applyhour_str.length == 0)
		{
			alert('<?=SIBO_APPLY_TIME_ERROR?>');
			return false;
		}
		if (form.select_time.value == 12)
 		{	
 			if (isNaN(form.user_time.value))
 			{
 				alert('<?=SIBO_NOT_NUMBER?>');
				return false;					
 			}
 			num = Number(form.user_time.value);
  			if ((num < 0) || (num > 59))
 			{
 				alert('<?=SIBO_NOT_NUMBER_MIN?>');
				return false;		
 			}
 		}
 	}
	else
	{
		if (form.start_hour.value == "" || form.end_hour.value == "" || form.start_min.value == "" || form.end_min.value == "" )
		{
			alert('<?=SIBO_USER_TIME_ERROR?>');
			return false;
		}
		if (isNaN(form.start_hour.value) || isNaN(form.end_hour.value) || isNaN(form.start_min.value) || isNaN(form.end_min.value))
		{
			alert('<?=SIBO_NOT_NUMBER?>');
			return false;			
		}
		num = Number(form.start_hour.value);
 		if ((num < 0) || (num > 24))
 		{
 			alert('<?=SIBO_NOT_NUMBER_HOUR?>');
			return false;		
 		}
		num = Number(form.start_min.value);
 		if ((num < 0) || (num > 59))
 		{
 			alert('<?=SIBO_NOT_NUMBER_MIN?>');
			return false;		
 		}	 		
 		num = Number(form.end_hour.value);
 		if ((num < 0) || (num > 24))
 		{
 			alert('<?=SIBO_NOT_NUMBER_HOUR?>');
			return false;		
 		}
 		num = Number(form.end_min.value);
 		if ((num < 0) || (num > 59))
 		{
 			alert('<?=SIBO_NOT_NUMBER_MIN?>');
			return false;		
 		}			
	}
	
	if (CheckTimePartOnce() == false)
	{
		return false;
	}
	
	var checkWeek = "";
	var length;
	var selectWeek = 0;
	for (var idx = 0, length = form.week.length ; idx < length ; idx++ ) 
	{
		if (idx < 7)
		{
			if (form.week[idx].checked)
			{
				checkWeek += "1";
				selectWeek = 1;
			}
			else
				checkWeek += "0";
		}
   	}
   	
   	if (selectWeek == 0)
	{
		alert('<?=SIBO_WEEK_ERROR?>');
		return false;
	}	
  	
	var submitParams = common_makeParams('s_name', name);
	submitParams += common_makeParams('sel_idx', listSelect);
	submitParams += common_makeParams('mod_set', '1');
	var fileName = "";
	var first = true;
	var bSelect = false;
	for ( var i = 0, l = select.options.length, o; i < l; i++ )
	{
		o = select.options[i];
  		if (o.selected)
  		{
  			bSelect = true;
  			if (first == true)
  			{
  				first = false;
  				fileName = o.value;
  			}
  			else
  			{
  				fileName += "," + o.value;	
  			}
  		}
  	}
 	
 	if (bSelect == false)
 	{
 		alert('<?=SIBO_TIME_CHECK_FILE ?>');
 		return false;
 	}
 	
 	if( !confirm('<?=SIBO_MOD_CONFIRM ?>') )
	{
		return false;
	}		
	
	submitParams += common_makeParams('fileSelect', fileName);
	
 	if (form.always.checked){
 		submitParams += common_makeParams('mode', '0');
 		var u_time = form.select_time.value;
 		if (u_time == 12)
 		{	// 사용자 정의
 			u_time = Number(form.user_time.value);
 			submitParams += common_makeParams('user_time', ((u_time<10) ?  "0"  :  "") + u_time);
 		}
 		else
 		{
 			 submitParams += common_makeParams('user_time',(((u_time*5)<10) ?  "0"  :  "") + (u_time*5));	// 5분간격으로 
 		}
 		
		submitParams += common_makeParams('apply_hour', applyhour_str);	
	
		submitParams += common_makeParams('start_time', '00:00');
		submitParams += common_makeParams('end_time', '00:00');
 	}
   	else{
   		submitParams += common_makeParams('mode', '1');
   		submitParams += common_makeParams('user_time', '0');
   		submitParams += common_makeParams('apply_hour', '0');
 		
 		var s_h = Number(form.start_hour.value);
 		var s_m = Number(form.start_min.value);
 		var e_h = Number(form.end_hour.value);
 		var e_m = Number(form.end_min.value);
 		
	   	var s_time = ((s_h<10) ?  "0"  :  "") + s_h + ":" + (((s_m)<10) ?  "0"  :  "") + s_m;
	   	var e_time = ((e_h<10) ?  "0"  :  "") + e_h + ":" + (((e_m)<10) ?  "0"  :  "") + e_m;
	   	
   		submitParams += common_makeParams('start_time', s_time);
   		submitParams += common_makeParams('end_time', e_time);	
   	}	
	submitParams += common_makeParams('week', checkWeek);
	common_smallviewLoader();
	setApply = true;
	new ajax.xhr.Request('/auth_clock/params/timeSignal/sibo_mod_process.php', submitParams, SubmitedForm, 'POST');
	return true;
}

function SetTimeName(name)
{
	document.getElementById('s_name').value = name;
}

function SetTimeoption(opt)
{
	var f = document.mainForm;
	if (opt == "0")
	{
		document.getElementById("always").checked = true;
	 	document.getElementById("once").checked = false;
 	
	 	document.getElementById("select_time").disabled = false;
	 	
		if (document.getElementById("select_time").value == 12)
			document.getElementById("user_part").style.visibility = "visible";
		else
			document.getElementById("user_part").style.visibility = "hidden";
		
		for (var i = 0; i < 24; i++)
		{
			f.u_hour[i].disabled = false;
		}
		document.getElementById("start_hour").disabled = true; 	
		document.getElementById("start_min").disabled = true; 	
		document.getElementById("end_hour").disabled = true; 	
		document.getElementById("end_min").disabled = true;
		time_mode = 0;			
	}	
	else
	{
		document.getElementById("always").checked = false;
	 	document.getElementById("once").checked = true;
	 	document.getElementById("select_time").disabled = true;
		document.getElementById("user_part").style.visibility = "hidden";	 	
		for (var i = 0; i < 24; i++)
		{
			f.u_hour[i].disabled = true;
		}
		document.getElementById("start_hour").disabled = false; 	
		document.getElementById("start_min").disabled = false; 	
		document.getElementById("end_hour").disabled = false; 	
		document.getElementById("end_min").disabled = false; 	
		time_mode = 1;	
	}
	
}

function SetMin_index(idx)
{
	if (time_mode == 0)
	{
		
		var index = Number(idx);
		
		if ((index % 5) == 0)	// combobox
		{
			document.getElementById("select_time").value = index / 5;
			document.getElementById("user_time").value = '';
			document.getElementById("user_part").style.visibility = "hidden";
		}	
		else	
		{
			document.getElementById("select_time").value = 12;
			document.getElementById("user_time").value = index; 
			document.getElementById("user_part").style.visibility = "visible";
		}
	}	
}

function SetWeekTime(week)
{
	var f = document.mainForm;
	for (var i = 0; i < 7; i++)
	{
		if (week.substr(i,1) == "1")
			f.week[i].checked = true;
		else
			f.week[i].checked = false;
	}
}

function SetFileSelect(file_name)
{
	var j = 0, l, o;
	
	var foo = new Array();
	foo = file_name.split('|');
	var select = document.getElementById("select_file");
	for ( j = 0, l = select.options.length, o; j < l; j++ )
	{
		o = select.options[j];
		o.selected = false;
	 }		
	for (var i = 0; i < foo.length; i++)
	{
		for (j = 0, l = select.options.length, o; j < l; j++ )
		{
	  		o = select.options[j];
	  		if (foo.length == 1)
	  		{
	  			if (o.value == foo)
	  				o.selected = true;	  			
	  		}
	  		else
	  		{
	  			if (o.value == foo[i])
	  				o.selected = true;
	  		}
	  	}			
	}
}

function SetApp_hour(hour)
{
	if (time_mode == 0)
	{
		var f = document.mainForm;
		for (var i = 0; i < 24; i++)
		{
			if (hour.substr(i,1) == "0")
			{
				f.u_hour[i].checked = false;
			}
			else
			{
				f.u_hour[i].checked = true;
			}
		}
	}
}

function SetStartTime(hour, min)
{
	if (time_mode == 1)
	{
		document.getElementById("start_hour").value = hour; 	
		document.getElementById("start_min").value = min; 
	}	
}

function SetEndTime(hour, min)
{
	if (time_mode == 1)
	{
		document.getElementById("end_hour").value = hour; 	
		document.getElementById("end_min").value = min; 
	}	
}

function SubmitedForm(req) 
{
	if( req.readyState == <?=READY_STAT_SUCCESS ?> ) {
		if( req.status == <?=STATUS_SUCCESS ?> ) {
		// 완료 알림
			common_smallhideLoader(0);
			if (setApply == true)
			{
				var result = req.responseText;
				var find_pos = result.search("sibo_already_playing");
				
				if (find_pos != -1)
				{
					alert('<?= SIBO_EDIT_RETRY_MSG ?>');
				}
				else 
				{
					find_pos = result.search("duplicate");
					
					if (find_pos != -1)
					{
						alert('<?=SIBO_TIME_DUPLICATE ?>');
					}
					else
					{
						alert('<?=SIBO_MOD_SUCCESS ?>');
					}	
				}
			}
			else
			{
				var first_pos,end_pos;
				
				var result = req.responseText;
				
				var first_pos = result.search("time_option");
				if (first_pos != -1)
					SetTimeoption(result.substr(first_pos+11,1));
				
				first_pos = result.search("min");
				end_pos = result.search("min_end");
				if (first_pos != -1)
					SetMin_index(result.substring(first_pos+3,end_pos));
				
				first_pos = result.search("apphour");
				end_pos = result.search("apphour_end");
				if (first_pos != -1)
					SetApp_hour(result.substring(first_pos+7,end_pos));
				
				first_pos = result.search("start_time");
				if (first_pos != -1)
					SetStartTime(result.substr(first_pos+10,2),result.substr(first_pos+13,2));	// start00:00
				
				first_pos = result.search("end_time");
				if (first_pos != -1)
					SetEndTime(result.substr(first_pos+8,2),result.substr(first_pos+11,2));	// end00:00
				
				first_pos = result.search("week_time");
				if (first_pos != -1)
					SetWeekTime(result.substr(first_pos+9,7));
				
				first_pos = result.search("time_name");
				end_pos = result.search("time_name_end");
				if (first_pos != -1)
					SetTimeName(result.substring(first_pos+9,end_pos));
				
				first_pos = result.search("set_file");
				end_pos = result.search("end_set");
				if (first_pos != -1)
					SetFileSelect(result.substring(first_pos+8,end_pos));
			}
		}
		else
		{
			// 정상이 아닌 case 메시지 출력
			common_notiServerState(req.status);
			common_hideLoader(<?=RESPONSE_ERROR ?>);
		}
	}
}
	
	function ServerTime(req)
	{
		if( req.readyState == <?=READY_STAT_SUCCESS ?> ) 
		{
			if( req.status == <?=STATUS_SUCCESS ?> ) 
			{
				// 완료 알림
				var result = req.responseText;
				
				var arrResponse = req.responseText.split("\n");
				var responseText = arrResponse[arrResponse.length - 1].replace(/<(.*?)>/gi,"");
				
				var len = responseText.length;
				var first_pos = responseText.search("stime");
				var second_pos = responseText.search("etime");
				var getstr = responseText.substring(first_pos+5,second_pos);
				var time_array = getstr.split(",");
				
				if( '<?=$document_language ?>' == '<?=LANG_KOR ?>' )
				{	// 한국 시간 표시
					if (time_array[6] == 1)
						dateval = time_array[0] + "." + time_array[1] + "." + time_array[2] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5] + "  DST";
					else
						dateval = time_array[0] + "." + time_array[1] + "." + time_array[2] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
				}
				else
				{	// 영문식 시간 표시 dd.mm.yy
					if (time_array[6] == 1)
						dateval = time_array[2] + "." + time_array[1] + "." + time_array[0] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5] + "  DST"; 
					else
						dateval = time_array[2] + "." + time_array[1] + "." + time_array[0] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
				}			
				Display_Clock(dateval);
			}
		}	
	}
	
	update_list(0);
</script> 