<?php
	include "/opt/interm/www/html/common/common_define.php";
	$copyright_homeLink = "http://www.inter-m.com";

$tz_name = array (	"Pacific/Kwajalein",
					"US/Samoa",
					"US/Hawaii",
					"US/Alaska",
					"US/Pacific",
					"US/Arizona",
					"US/Mountain",
					"US/Central",
					"America/Mexico_City",
					"Canada/Saskatchewan",
					"America/Lima",
					"US/Eastern",
					"US/East-Indiana",
					"Canada/Atlantic",
					"America/Caracas",
					"America/Santiago",
					"Canada/Newfoundland",
					"Brazil/East",
					"America/Argentina/Buenos_Aires",
					"Atlantic/South_Georgia",
					"Atlantic/Azores",
					"Europe/London",
					"Europe/Amsterdam",
					"Europe/Belgrade",
					"Europe/Brussels",
					"Europe/Sarajevo",
					"Europe/Athens",
					"Europe/Bucharest",
					"Africa/Cairo",
					"Africa/Harare",
					"Europe/Helsinki",
					"Asia/Tel_Aviv",
					"Asia/Baghdad",
					"Europe/Moscow",
					"Africa/Nairobi",
					"Asia/Tehran",
					"Asia/Dubai",
					"Asia/Tbilisi",
					"Asia/Kabul",
					"Asia/Yekaterinburg",
					"Asia/Karachi",
					"Asia/Calcutta",
					"Asia/Almaty",
					"Asia/Colombo",
					"Asia/Bangkok",
					"Asia/Hong_Kong",
					"Australia/Perth",
					"Asia/Singapore",
					"Asia/Taipei",
					"Asia/Tokyo",
					"Asia/Seoul",
					"Asia/Yakutsk",
					"Australia/Adelaide",
					"Australia/Darwin",
					"Australia/Brisbane",
					"Australia/Canberra",
					"Pacific/Port_Moresby",
					"Australia/Hobart",
					"Asia/Vladivostok",
					"Asia/Magadan",
					"Pacific/Auckland");	
						
	$xmls = simplexml_load_file(SIBO_CONF_XML);
	$sibo_Max = common_xmlReader($xmls, XML_SIBO_MAX);
	
	$loadxml = simplexml_load_file(TIME_CONF_XML);
	
	$time_zone_idx = common_xmlReader($loadxml, XML_TIME_ZONE_INDEX);
	
	date_default_timezone_set($tz_name[(int)$time_zone_idx]);
	$today = time(); 

	$manual_year 	= date('Y');
	$manual_month	= date('m');
	$manual_day		= date('d');
	$manual_hour 	= date('H');
	$manual_minute 	= date('i');
	$manual_second 	= date('s');
	$daylight_time  = date('I');
	
    $confxml = simplexml_load_file(VERSION_CONF_XML);
    $model_name = common_xmlReader($confxml, XML_MODEL_NAME);
    if ($model_name == "")
        $model_name = "ARM-911";   
    if ($model_name == null)
        $model_name = "ARM-911";	
?>

<html>
	
<head>
	<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
	
	<meta http-equiv="cache-control" content="no-cache" />
	<meta http-equiv="expires" content="0" />
	<meta http-equiv="pragma" content="no-cache" />
   	<link rel="stylesheet" href="<?=CSS_STYLE_PATH3 ?>" type="text/css" />
   	
	<link rel="shortcut icon" href=<?=FAVICON_PATH ?> />

   	<meta name="author"     content="Inter-M" />
    <meta name="keywords"   content="<?=$model_name ?>" />
	<script language="javascript" src="/js/jquery_last.js"></script>
	<script language="javascript" src="/js/jquery.filestyle.js"></script>
	<script language="javascript" src="/js/ajaxfileupload.js"></script>
	<script language="javascript" src="/js/common_request.js"></script>
	
</head>
	
<body onload="Clock();" onunload="CloseTimer();">
	<table border="0" cellpadding="2" style="width:100%;">
		<tr>
			<td style="width:9%;">
				<img src="./img/LOGO.png" width="100" border="0">
			</td>
			<td style="font-family:sans-serif;font-size:20px;width:82%;"><?=SIBO_CENTER_STR1 ?></td>
			<td>
				<span id="clock" style="width:85px;"></span>		
			</td>
		</tr>
	</table>

	<?include "/opt/interm/www/html/auth_clock/params/timeSignal/center.php" ?>
	
	<table border="0" cellpadding="2" style="width: 100%;">
		<tr>
			<td class="td_copyright_font">
				<center>
					Copyright (c) 2012 <b><a href=<?=$copyright_homeLink ?> target="_new">Inter-M</a></b> All rights reserved.
				</center>
			</td>
		</tr>
	</table>
</body>
</html>

<script language="JavaScript"> 
	var timer;//전역 변수 선언.
	var first = true;
	var curTime = 0;
	var g_year = '<?=$manual_year ?>';
	var g_month = '<?=$manual_month ?>';
	var g_day = '<?=$manual_day ?>';
	var g_hour = '<?=$manual_hour ?>';
	var g_minute = '<?=$manual_minute ?>';
	var g_second = '<?=$manual_second ?>';
	var g_dstSet = '<?=$daylight_time ?>';
		
   function Clock() 
    {
        $.ajax({
            url:"/conf/emitTime.txt",
            type:"POST",
            timeout:1000,
            async: true,
            dataType: "text",
            cache:false,
            success: function(output){
              Display_Clock(output);
              }
        });
        if (timer != 0)
            clearTimeout(timer);
        timer = setTimeout("Clock()", 1000);
    }
    
    function Display_Clock(time_str)
    {
        var clock = document.getElementById("clock");         // 출력할 장소 선택
        clock.innerHTML = time_str;         // 현재시간을 출력
    }
            
    function CloseTimer()
    {
        clearTimeout(timer);
        timer = 0;  
    }
	
	function ServerTime(req)
	{
		if( req.readyState == <?=READY_STAT_SUCCESS ?> ) 
		{
			if( req.status == <?=STATUS_SUCCESS ?> ) 
			{
				// 완료 알림
				var arrResponse = req.responseText.split("\n");
				var responseText = arrResponse[arrResponse.length - 1].replace(/<(.*?)>/gi,"");
				
				var len = responseText.length;
				var first_pos = responseText.search("stime");
				var second_pos = responseText.search("etime");
				var getstr = responseText.substring(first_pos+5,second_pos);
				var time_array = getstr.split(",");
				
				if( '<?=$document_language ?>' == '<?=LANG_KOR ?>' )
				{	// 한국 시간 표시
					if (time_array[6] == 1)
						dateval = time_array[0] + "." + time_array[1] + "." + time_array[2] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5] + " s";
					else
						dateval = time_array[0] + "." + time_array[1] + "." + time_array[2] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
				}
				else
				{	// 영문식 시간 표시 dd.mm.yy
					if (time_array[6] == 1)
						dateval = time_array[2] + "." + time_array[1] + "." + time_array[0] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5] + " s"; 
					else
						dateval = time_array[2] + "." + time_array[1] + "." + time_array[0] + " / " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
				}			
				Display_Clock(dateval);
			}
		}	
	}	
</script>
