<?php
function common_xmlReader($xmls, $nodePath) {
	if ($xmls == "")
		return 0;
	$nodeExists = $xmls -> xpath($nodePath);

	return $nodeExists[0];
};

function common_xmlWriter($xmlFile, $nodePath, $value) {
	$xml = simplexml_load_file($xmlFile);
	$nodeExists = $xml -> xpath($nodePath);
	$nodeExists[0][0] = $value;
	$xml -> asXML($xmlFile);
};

function common_xmlSave($xmls, $xmlFile)
{
	$xmls -> asXML($xmlFile);
};

function common_xmlWriteWithoutSave($xml, $nodePath, $value) 
{
	$nodeExists = $xml -> xpath($nodePath);
	$nodeExists[0][0] = $value;
};

function common_xmlWriterToAttribute($xmls, $nodePath, $attri, $value)
{
	$nodeExists = $xmls -> xpath($nodePath);
	$nodeExists[0][$attri] = $value;
};

function common_xmlRemoveFromIndex($xmls, $nodePath, $del)
{
	$url = $nodePath.$del.'"]';
	$nodeExists = $xmls -> xpath($url);
	$cnt = count($nodeExists[0]);
	for ($idx = 0; $idx < $cnt; $idx++)
	{
		unset($nodeExists[0][$idx]);
	}
};

function common_xmlReader_node($xml, $nodePath)
{
    if ($xml == "")
        return 0;
    $nodeExists = $xml -> xpath($nodePath);
    return $nodeExists;
};



function common_displayHelp() {
	$numArgs = func_num_args();
	$argList = func_get_args();

	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" align=\"center\">";
	echo "  <tr>";
	echo "      <td width=\"600\">";
	echo "          <hr>";
	echo "      </td>";
	echo "  </tr>";

	echo "  <tr>";
	echo "      <td class=\"help_td_font\" width=\"600\">";
	echo "          *&nbsp;Help&amp;Tips";
	echo "      </td>";
	echo "  </tr>";

	echo "  <tr>";
	echo "      <td class=\"help_msg_font\" width=\"600\" style=\"padding:5\">";
	echo "          <ul>";
	for ($idx = 0; $idx < $numArgs; $idx++) {
		echo "              <li>" . $argList[$idx] . "</li>";
	}
	echo "          </ul>";
	echo "      </td>";
	echo "  </tr>";

	echo "  <tr>";
	echo "      <td width=\"600\">";
	echo "          <hr>";
	echo "      </td>";
	echo "  </tr>";

	echo "</table>";
};

/*
function common_logWrite($message) {
	$logFp = fopen(LOG_FILE_PATH, "a");

	$logFormat = "[" . date("Y/m/d H:i:s", time()) . "] " . $message . "\r\n";
	fwrite($logFp, $logFormat);
	
	fclose($fp);
};
*/

function common_logWrite($message) 
{
	$cmd = 'su -c "'.'/opt/interm/bin/rlog -f /opt/interm/www/html/log/interm_log.dat -w \"'.$message.'\" 2>&1 "';
	shell_exec($cmd);	
};

function common_trans_log()
{
	$cmd = 'su -c "'.'/opt/interm/bin/rlog -f /opt/interm/www/html/log/interm_log.dat -r > /opt/interm/bin/trans_log.txt"';
	shell_exec($cmd);	
};

function gen_checksum($data,$cnt)
{
	$total = 0;
	for ($i = 1; $i <= $cnt; $i++)
	{
		$total += hexdec($data[$i]);
	}
	$total = $total % 256;
	$total = 256 - $total;
	
	return dechex($total);
};


function common_restartConfig($parameter) {
	$cmd = 'su -c "' . RESTART_CONF_PATH . ' ' . $parameter . ' 2>&1 "';
	
	return shell_exec('su -c "' . RESTART_CONF_PATH . ' ' . $parameter . ' 2>&1 "');
};

function common_listenTo($mode, $path, $stat) {
	return shell_exec(LISTEN_TO_PATH . ' -mode ' . $mode . ' ' . $path . ' ' . $stat);
};

function common_refreshPage() {
	header("location:" . $_SERVER["REQUEST_URI"]);
};

function common_processKill($pName) {
	shell_exec('su -c "killall -SIGTERM ' . $pName . '"');
};

function common_changeHostname($hostName) {
	shell_exec('su -c "hostname ' . $hostName . '"');
};

function common_KillSibo()
{
    shell_exec('su -c "killall -SIGTERM action_prc"');
    shell_exec('su -c "killall -SIGTERM schedule_prc"');
    shell_exec('su -c "killall -SIGTERM audio_player"');
    
    sleep(2);
}

function common_KillSchedule()
{
    shell_exec('su -c "killall -SIGTERM action_prc"');
    shell_exec('su -c "killall -SIGTERM schedule_prc"');
    shell_exec('su -c "killall -SIGTERM audio_player"');
    
    sleep(2);
}


function common_KillConfManager()
{
	shell_exec('su -c "killall -9 confManager"');
}

function common_restartConfManager()
{
	shell_exec('su -c "/opt/interm/bin/confManager > /dev/null 2>&1 &"');
}

function common_reboot()
{
	shell_exec('su -c "/sbin/reboot"');
}

function common_restartSibo()
{
    shell_exec('su -c "/opt/interm/bin/action_prc > /dev/null 2>&1 &"');
    shell_exec('su -c "/opt/interm/bin/schedule_prc > /dev/null 2>&1 &"');    
}

function common_fwUpgrade($type)
{
	if ($type == 1)
		shell_exec('su -c "/opt/interm/bin/fw_test main > /dev/null 2>&1 &"');
	else if ($type == 2)
		shell_exec('su -c "/opt/interm/bin/fw_test rm1 > /dev/null 2>&1 &"');
	else if ($type == 3)
		shell_exec('su -c "/opt/interm/bin/fw_test rm2 > /dev/null 2>&1 &"');
	else if ($type == 4)
		shell_exec('su -c "/opt/interm/bin/fw_test rm3 > /dev/null 2>&1 &"');
	else if ($type == 5)
		shell_exec('su -c "/opt/interm/bin/fw_test rm4 > /dev/null 2>&1 &"');
	else
		return FALSE;
}

function common_sendMsgtoConfManager($msg)
{
	shell_exec('su -c "/opt/interm/bin/send_msg '.$msg.' "');
}

function common_playstop($cmd,$url)
{
	if ($cmd == '1')
	{
		common_logWrite($cmd.'--'.$url);
		shell_exec('su -c "killall -SIGTERM audio_player"');
		shell_exec('su -c \'/opt/interm/bin/audio_player "'.$url.'" 2>&1 &\'');
	}
	else
	{
		common_logWrite('Player stop!!');
		shell_exec('su -c "killall -SIGTERM audio_player"');
	}
}

function common_isPlay_audioplayer() {
    $isPlaySibo = shell_exec('ps -ef | grep audio_player');
    $resultArr  = explode("\n",$isPlaySibo);
    
    for($idx = 0; $idx < count($resultArr); ++$idx) {
        
        if(strpos($resultArr[$idx], "/opt/interm/bin/audio_player") == true ) {
            return TRUE; 
        } 
    } 
    
    return FALSE;
}

function common_previewListen($file)
{
	$url = MP3_PATH.$file;
	common_playstop('1',$url);
}

function common_operKillAll() {
	//common_processKill(CONN_TYPE_USB);
	common_processKill(CONN_TYPE_AOE_RUNNER);
	common_processKill(CONN_TYPE_AOE);
	common_processKill(CONN_TYPE_RADIO);
}

function common_operRadioKill() {
	//common_processKill(CONN_TYPE_USB);
	common_processKill(CONN_TYPE_RADIO);
}

function common_operAoeKill() {
	common_processKill(CONN_TYPE_AOE_RUNNER);
	common_processKill(CONN_TYPE_AOE);
}

function common_getRefreshStat($flag) {
	if ($_SERVER['REQUEST_METHOD'] == METHOD_POST && $_POST['form']) {
		$flag = false;
	}

	if ($flag == true) {
		return DISPLAY_ENABLE;

	} else {
		return DISPLAY_DISABLE;
	}
};
?>

<script language="javascript">

	function common_getExt(fileName) 
	{
		var str = fileName.value;
		var str1 = str.split('.');
		ext = str1[str1.length - 1];
		return ext;
	}

	function common_alert(message) {
		alert(message);
	}

	function common_setLanguage(form, setLang) 
	{
        $.ajax({
            type: "GET",
            url: "/setLanguage.php?topLangSet="+setLang,
            data: setLang,
            success: function(){    
                location.reload();   
            }
        });
        return true;
	}

	function common_nullFunction() {
		return false;
	}	

	var global_paramsCount = 0;
	function common_makeParams(name, value) {
		var params = "";
		
		if( global_paramsCount != 0 ) {
			params = "&";
		}
		params += name + "=" + value;
		global_paramsCount++;
		
		return params;
	}
	
	function common_viewLoader() {
		document.body.focus();
		$('#viewLoading').fadeIn(400);
		$("#viewBackground").css('opacity','0.3').fadeIn(400);
	}
	
	function common_hideLoader(setTime) {
		if( setTime == <?=RESPONSE_SUCCESS ?> ) {
			$('#viewLoading').fadeOut(400);
			$('#viewBackground').fadeOut(400);

			setTimeout ("", 400);

		} else if( setTime == <?=RESPONSE_ERROR ?> ) {
			$('#viewLoading').fadeOut(400);
			$('#viewBackground').fadeOut(400);
			
		} else {
			var num = 0;
			var inputbox = document.getElementById("percentView");
			inputbox.innerHTML = "<table><tr><td height=30><p class=td_menu_font>loading... " + num + "% </p></td></tr></table>";

			$('#percentView').fadeIn(400);
			
			setTime *= 1000;
			var max = 100;
			var interval = setInterval(function() {
							   	num += 1;
							    inputbox.innerHTML = "<table><tr><td height=30><p class=td_menu_font>loading... " + num + "% </p></td></tr></table>";
							    if(num >= max) clearInterval(interval);
							}, (setTime - 1200) / max);

			setTimeout ("$('#viewLoading').fadeOut(400)", setTime);
			setTimeout ("$('#viewBackground').fadeOut(400)", setTime);
			setTimeout ("$('#percentView').fadeOut(400)", setTime);

			setTimeout ("", setTime + 400);
		}
	}
	
	function common_notiServerState(state) {
		switch( state ) {
			case <?=STATUS_FORBIDDEN ?> : 
				alert('[' + <?=STATUS_FORBIDDEN ?> + '] ' + '<?=STATUS_FORBIDDEN_MSG ?>');
				break;
				
			case <?=STATUS_NOT_FOUND ?> :
				alert('[' + <?=STATUS_NOT_FOUND ?> + '] ' + '<?=STATUS_NOT_FOUND_MSG ?>');	
				break;
				
			case <?=STATUS_INT_ERROR ?> :
				alert('[' + <?=STATUS_NOT_FOUND ?> + '] ' + '<?=STATUS_NOT_FOUND_MSG ?>');		
				break;
			
			default :
				alert('[' + state + '] ' + '<?=STATUS_UNKNOWN_ERR_MSG ?>');	
				break;
		}	
	}
	
	
</script>
