<?php
include "../../common/common_define.php";

$loadXml = simplexml_load_file(AOE_CONN_CONF_XML);

$aoeConn_baseIpAddr = common_xmlReader($loadXml, AOE_CONN_IP_ADDR_PATH);
$aoeConn_basePort = common_xmlReader($loadXml, AOE_CONN_PORT_PATH);
$aoeConn_baseMcastAddr = common_xmlReader($loadXml, AOE_CONN_MCAST_ADDR_PATH);
$aoeConn_baseMcastPort = common_xmlReader($loadXml, AOE_CONN_MCAST_PORT_PATH);
$aoeConn_baseBufferRate = common_xmlReader($loadXml, AOE_CONN_BUFFER_RATE_PATH);
$aoeConn_baseEnable = common_xmlReader($loadXml, AOE_CONN_ENABLE_PATH);
$aoeConn_baseCastType = common_xmlReader($loadXml, AOE_CONN_CAST_TYPE_PATH);

common_logWrite(AOE_CONN_SET_START_LOG_MSG);
// common_operAoeKill();
	
// cast type
if( !empty($_POST['typeUnicast']) )  {
	$aoeConn_castType = TYPE_UNICAST;	
	$aoeConn_typeIpAddr = $aoeConn_baseIpAddr;
	$aoeConn_typePort	= $aoeConn_basePort;
	$aoeConn_xmlIpAddrPath	= AOE_CONN_IP_ADDR_PATH;
	$aoeConn_xmlPortPath	= AOE_CONN_PORT_PATH;

} else {
	$aoeConn_castType = TYPE_MULTICAST;	
	$aoeConn_typeIpAddr = $aoeConn_baseMcastAddr;
	$aoeConn_typePort	= $aoeConn_baseMcastPort;
	$aoeConn_xmlIpAddrPath	= AOE_CONN_MCAST_ADDR_PATH;
	$aoeConn_xmlPortPath	= AOE_CONN_MCAST_PORT_PATH;
}

if( $aoeConn_baseCastType != $aoeConn_castType ) {
	common_xmlWriter(AOE_CONN_CONF_XML, AOE_CONN_CAST_TYPE_PATH, $aoeConn_castType);
	common_logWrite(AOE_CONN_SETUP." - ".AUDIO_MODE." [".$aoeConn_baseCastType."] -> [".$aoeConn_castType."]");
}

// aoe ip
if( ($aoeConn_newIpAddr = $_POST['aoeConnIpAddr']) ) {
	if( $aoeConn_typeIpAddr != $aoeConn_newIpAddr ) { 
		common_xmlWriter(AOE_CONN_CONF_XML, $aoeConn_xmlIpAddrPath, $aoeConn_newIpAddr);
		common_logWrite(AOE_CONN_SETUP." - ".SERVER_ADD_STR." [".$aoeConn_typeIpAddr."] -> [".$aoeConn_newIpAddr."]");
	}
}

// aoe port 
if( ($aoeConn_newPort = $_POST['aoeConnPort']) ) {
	if( $aoeConn_typePort != $aoeConn_newPort ) { 
		common_xmlWriter(AOE_CONN_CONF_XML, $aoeConn_xmlPortPath, $aoeConn_newPort);
		common_logWrite(AOE_CONN_SETUP." - ".PORT_STR." [".$aoeConn_typePort."] -> [".$aoeConn_newPort."]");
	}
}

// buffer rate
$aoeConn_newBufferRate = $_POST['aoeConnBufferRate'];
if( isset($aoeConn_newBufferRate) ) {
	if( $aoeConn_baseBufferRate != $aoeConn_newBufferRate ) {
		common_xmlWriter(AOE_CONN_CONF_XML, AOE_CONN_BUFFER_RATE_PATH, $aoeConn_newBufferRate);
		common_logWrite(AOE_CONN_SETUP." - ".AUDIO_BUFFER_RATE." [".$aoeConn_baseBufferRate."] -> [".$aoeConn_newBufferRate."]");
	}
}

// client enable
if( !empty($_POST['aoeConnEnable']) ) {
	$aoeConn_enable = ENABLE_YES;
	common_listenTo(TYPE_AOE, LISTEN_TO_NONE_PATH, LISTEN_TO_STAT_STOP);
	common_listenTo(TYPE_AOE, LISTEN_TO_NONE_PATH, LISTEN_TO_STAT_PLAY);
} else {
	$aoeConn_enable = ENABLE_NO;
	common_listenTo(TYPE_AOE, LISTEN_TO_NONE_PATH, LISTEN_TO_STAT_STOP);
}

if( $aoeConn_baseEnable != $aoeConn_enable ) {
	common_xmlWriter(AOE_CONN_CONF_XML, AOE_CONN_ENABLE_PATH, $aoeConn_enable);
	common_logWrite(AOE_CONN_SETUP." - ".ENABLE." [".$aoeConn_baseEnable."] -> [".$aoeConn_enable."]");
}

common_logWrite(AOE_CONN_SET_END_LOG_MSG);
// common_restartConfig(SET_AUDIO);
?>