<?php

$loadXml = simplexml_load_file(AUDIO_CONF_XML);
if( common_xmlReader($loadXml, AUDIO_SERVER_TYPE) == TYPE_UNICAST) {
	$server_serverIpAddr = common_xmlReader($loadXml, AUDIO_SERVER_MCAST_IP);
	$server_serverPort	 = common_xmlReader($loadXml, AUDIO_SERVER_PORT_PATH);
	$server_unicast_disable = "disabled";

} else {
	$server_serverIpAddr = common_xmlReader($loadXml, AUDIO_SERVER_MCAST_IP);
	$server_serverPort	 = common_xmlReader($loadXml, AUDIO_SERVER_MCAST_PORT);
	$server_unicast_disable = "";
}

if( common_xmlReader($loadXml, AUDIO_RECEIVE_ENABLE_PATH) == ENABLE_YES ) {
	$server_enable = DISPLAY_CHECKED;

} else {
	$server_enable = "";
}

if( common_xmlReader($loadXml, AUDIO_SERVER_MODE) == MODE_RTSP ) {
	$server_rtsp_disable = "disabled";
	$server_unicast_disable = "disabled";
	
} else {
	$server_rtsp_disable = "";
}

$server_sampleRate = common_xmlReader($loadXml, AUDIO_SERVER_SAMPLE_RATE);
$server_channels   = common_xmlReader($loadXml, AUDIO_SERVER_CHANNELS);

$server_sampleArr[0] = 16000;
$server_sampleArr[1] = 32000;
$server_sampleArr[2] = 44100;
$server_sampleArr[3] = 48000;

for( $idx = 0 ; $idx < 4 ; $idx++ ) {
	if( $server_sampleArr[$idx] == $server_sampleRate ) {
		$server_sampleArr[$idx] = SELECTED_ENABLE;

	} else {
		$server_sampleArr[$idx] = "";
	}
}

$server_channelArr[0] = 1;
$server_channelArr[1] = 2;

for( $idx = 0 ; $idx < 2 ; $idx++ ) { 
	if( $server_channelArr[$idx] == $server_channels ) {
		$server_channelArr[$idx] = SELECTED_ENABLE;

	} else {
		$server_channelArr[$idx] = "";
	}
}

?>

<!-- menu server section -->
<table border="0" cellpadding="2" width="600">
	<tr>
		<td width="20"></td>
		<td class="td_name_bg" nowrap width="200">
				<table border="0" cellpadding="0" cellspacing="0" width="200">
					<tr>
						<td width="10">
						</td>

						<td class="td_name_font" width="190"> 
								<?=AUDIO_SERVICE ?>
						</td>
					</tr>	
				</table>
		</td>

		<td class="td_menu_bg" width="400">
				<table class="td_menu_font" border="0" cellpadding="0" cellspacing="0" width="400">
						<tr>
								<td width="20" height="30">
								</td>

								<td width="130"> 
										<?=AUDIO_SAMPLING ?>
								</td>

								<td width="150">
									<select name="audioSampleRate" <?=$server_rtsp_disable ?> >
										<option value="16000" <?=$server_sampleArr[0] ?> >16000</option>
										<option value="32000" <?=$server_sampleArr[1] ?> >32000</option>
										<option value="44100" <?=$server_sampleArr[2] ?> >44100</option>
										<option value="48000" <?=$server_sampleArr[3] ?> >48000</option>
									</select>
								</td>

								<td width="100"> 
								</td>
						</tr>

						<tr>
								<td width="20" height="30">
								</td>

								<td width="130">
									<?=AUDIO_CHANNELS ?>
								</td>

								<td width="150">
									<select name="audioChannels" <?=$server_rtsp_disable ?> >
										<option value="1" <?=$server_channelArr[0] ?> >1</option>
										<option value="2" <?=$server_channelArr[1] ?> >2</option>
									</select>

								</td>

								<td width="100"> 
								</td>
						</tr>

						<tr>
								<td width="20" height="30">
								</td>

								<td width="130">
									<?=RTP_ADDR ?>
								</td>

								<td width="150">
									<input type="text" size="15" maxlength="15" name="audioServerIpAddr" <?=$server_unicast_disable ?> value="<?=$server_serverIpAddr ?>">
								</td>

								<td width="100">
								</td>

						</tr>

						<tr>
								<td width="20" height="30">
								</td>

								<td width="130">
									<?=PORT_STR ?>
								</td>

								<td width="150">
									<input type="text" size="4" maxlength="5" name="audioServerPort" value="<?=$server_serverPort ?>">
								</td>

								<td width="100">
								</td>

						</tr>

						<tr>
								<td width="20" height="30">
								</td>

								<td width="130">
										<?=ENABLE ?>
								</td>

								<td width="150">
										<input type="checkbox" name="audioServerEnable" <?=$server_enable ?> onClick="CheckServerEnable(this.form)"</p>
								</td>

								<td width="100">
								</td>
						</tr>
				</table>
		</td>
	</tr>
</table>

<script>
	if( '<?=$server_enable ?>' == "" ) {
		document.mainForm.audioSampleRate.disabled = true;
		document.mainForm.audioChannels.disabled = true;
		document.mainForm.audioServerIpAddr.disabled = true;
		document.mainForm.audioServerPort.disabled = true;
	}
</script>


