<?php
include "../../common/common_define.php";

$loadXml                = simplexml_load_file(NETWORK_CONF_XML);
$unicast_mac_addr    	= common_xmlReader($loadXml, XML_NETWORK_MAC_PATH);
$unicast_host_name      = common_xmlReader($loadXml, XML_NETWORK_HOSTNAME_PATH);
$unicast_dhcp           = common_xmlReader($loadXml, XML_NETWORK_DHCP_PATH);
$unicast_ip_addr        = common_xmlReader($loadXml, XML_NETWORK_IP_PATH);
$unicast_subnet_mask    = common_xmlReader($loadXml, XML_NETWORK_NETMASK_PATH);
$unicast_gateway        = common_xmlReader($loadXml, XML_NETWORK_GATEWAY_PATH);
$unicast_dns1_server    = common_xmlReader($loadXml, XML_NETWORK_DNS1_PATH);
$unicast_dns2_server    = common_xmlReader($loadXml, XML_NETWORK_DNS2_PATH);

common_logWrite(NETWORK_SET_START_LOG_MSG);
if( ($post_hostname	=	$_POST['hostname']) ) {
	if($post_hostname != $unicast_host_name) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_HOSTNAME_PATH, $post_hostname);
		common_logWrite(NETWORK_SETUP." - ".HOST_NAME_STR." [".$unicast_host_name."] -> [".$post_hostname."]");
		
		common_changeHostname($post_hostname);
	}
} 

if( !empty( $_POST['setDhcp'] ) ) {
	if($unicast_dhcp != ENABLE_YES) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_DHCP_PATH, ENABLE_YES);
		common_logWrite(NETWORK_SETUP." - ".IP_SET_TYPE_STR." [".STATIC_IP_STR."] -> [".DHCP_IP_STR."]");	
	}				
}  

if( !empty($_POST['setStatic'] ) ) {
	if($unicast_dhcp != ENABLE_NO) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_DHCP_PATH, ENABLE_NO );
		common_logWrite(NETWORK_SETUP." - ".IP_SET_TYPE_STR." [".DHCP_IP_STR."] -> [".STATIC_IP_STR."]");	
	}		
}

if( $post_ip_addr = $_POST['ipaddr'] ) {
	if( $post_ip_addr != $unicast_ip_addr )	{
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_IP_PATH, $post_ip_addr);
		common_logWrite(NETWORK_SETUP." - ".IP_ADDR_STR." [".$unicast_ip_addr."] -> [".$post_ip_addr."]");	
	}
}
	 
if( $post_subnet = $_POST['subnet']	) {
	if( $post_subnet != $unicast_subnet_mask) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_NETMASK_PATH, $post_subnet );
		common_logWrite(NETWORK_SETUP." - ".SUBNET_MAST_STR." [".$unicast_subnet_mask."] -> [".$post_subnet."]");	
	}	
}

if( $post_gateway = $_POST['gateway'] ) {
	if( $post_gateway != $unicast_gateway ) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_GATEWAY_PATH, $post_gateway);
		common_logWrite(NETWORK_SETUP." - ".GATE_WAY_STR." [".$unicast_gateway."] -> [".$post_gateway."]");	
	}
}

if( $post_dns1 = $_POST['dns1'] ) {
	if( $post_dns1 != $unicast_dns1_server ) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_DNS1_PATH, $post_dns1);
		common_logWrite(NETWORK_SETUP." - ".DNS_1_STR." [".$unicast_dns1_server."] -> [".$post_dns1."]");	
	}		
}

if( $post_dns2 = $_POST['dns2'] ) {
	if( $post_dns2 != $unicast_dns2_server ) {
		common_xmlWriter(NETWORK_CONF_XML, XML_NETWORK_DNS2_PATH, $post_dns2 );
		common_logWrite(NETWORK_SETUP." - ".DNS_2_STR." [".$unicast_dns2_server."] -> [".$post_dns2."]");	
	}		
}
common_restartConfig(SET_NETWORK);
common_logWrite(NETWORK_SET_END_LOG_MSG);

?>
