<?php
	include "../../common/common_define.php";
	
	$xmls = simplexml_load_file(AUX_CONF_XML);
	$aux_packet = "";
	$packet = Array("");
	
	function gen_packet_aux($aux_type, $aux_id, $aux_value)
	{
		global $aux_packet;
		global $packet;		
		$packet[0] = dechex(0x5b);
		if ($aux_type == 'type')
			$packet[1] = dechex(0x11);
		else if ($aux_type == 'pad')
			$packet[1] = dechex(0x12);
		else if ($aux_type == 'phantom')
			$packet[1] = dechex(0x13);
		else 
			return;
		
		if ($aux_id == 'aux1')
			$packet[2] = dechex(0x0);
		else
			$packet[2] = dechex(0x1);
		
		$packet[3] = dechex(0x01);
		
		if ($aux_value == 'mic' || $aux_value == 'off')
			$packet[4] = dechex(0x0);
		else if ($aux_value == 'line' || $aux_value == 'on')
			$packet[4] = dechex(0x1);
		else if ($aux_value == 'line2')
			$packet[4] = dechex(0x2);
		
		$packet[5] = gen_checksum($packet, 4);
		$packet[6] = dechex(8);
		$packet[7] = dechex(0x5d);
		for ($i = 0; $i < 8; $i++)
			$aux_packet .= (hexdec($packet[$i]) < 16) ? ('0'.($packet[$i])) : ($packet[$i]);	
	};
	
	if ($_POST['type1'] != "")
	{
		gen_packet_aux('type', 'aux1', $_POST['type1']);
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX1_TYPE, $_POST['type1']);	
		common_logWrite('aux1 type changed! : '.$_POST['type1']);
	}
	 
	if ($_POST['type2'] != "")
	{
		gen_packet_aux('type', 'aux2', $_POST['type2']);
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX2_TYPE, $_POST['type2']);	
		common_logWrite('aux2 type changed! : '.$_POST['type2']);
	}

	if ($_POST['pad1'] != "")
	{
		gen_packet_aux('pad', 'aux1', $_POST['pad1']);
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX1_PAD, $_POST['pad1']);	
		common_logWrite('aux1 pad changed! : '.$_POST['pad1']);
	}	
	
	if ($_POST['pad2'] != "")
	{
		gen_packet_aux('pad', 'aux2', $_POST['pad2']);
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX2_PAD, $_POST['pad2']);	
		common_logWrite('aux2 pad changed! : '.$_POST['pad2']);
	}

	if ($_POST['phan1'] != "")
	{
		gen_packet_aux('phantom', 'aux1', $_POST['phan1']);
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX1_PHANTOM, $_POST['phan1']);	
		common_logWrite('aux1 phantom changed! : '.$_POST['phan1']);		
	}
	
	if ($_POST['phan2'] != "")
	{
		gen_packet_aux('phantom', 'aux2', $_POST['phan2']);
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX2_PHANTOM, $_POST['phan2']);	
		common_logWrite('aux2 phantom changed! : '.$_POST['phan2']);		
	}
	
	if ($_POST['default'] == '1')
	{
		gen_packet_aux('type', 'aux1', 'line');
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX1_TYPE, 'line');
		$aux_packet = "";
		gen_packet_aux('type', 'aux2', 'line');
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX2_TYPE, 'line');
		$aux_packet = "";
		gen_packet_aux('pad', 'aux1', 'off');
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX1_PAD, 'off');
		$aux_packet = "";
		gen_packet_aux('pad', 'aux2', 'off');
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX2_PAD, 'off');
		$aux_packet = "";
		gen_packet_aux('phantom', 'aux1', 'off');
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX1_PHANTOM, 'off');
		$aux_packet = "";
		gen_packet_aux('phantom', 'aux2', 'off');
		common_sendMsgtoConfManager($aux_packet);
		common_xmlWriteWithoutSave($xmls, XML_AUX2_PHANTOM, 'off');
		$aux_packet = "";
		
		common_logWrite('aux1,aux2 default changed!');
	}
	common_xmlSave($xmls, AUX_CONF_XML);	
	
?>