<?php

$dayofWeek = array("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT");
$sibo_file = array();
$time_option = array();
$time_min = array();
$time_hour = array();
$time_start = array();
$time_end = array();
$time_week = array();
$temp_hour = array();
$time_file = array();

$file_name = array();

$loadxml = simplexml_load_file(SIBO_CONF_XML);

$sibo_Max = common_xmlReader($loadxml, XML_SIBO_MAX);

for ($idx=0; $idx < $sibo_Max; $idx++)
{
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/name';
	$sibo_file[$idx] = common_xmlReader($loadxml,$s_name);
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/time_option';
	$time_option[$idx] = common_xmlReader($loadxml,$s_name);
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/option_min';
	$time_min[$idx] = common_xmlReader($loadxml,$s_name);
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/hour';
	$time_hour[$idx] = common_xmlReader($loadxml,$s_name);
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/start';
	$time_start[$idx] = common_xmlReader($loadxml,$s_name);
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/end';
	$time_end[$idx] = common_xmlReader($loadxml,$s_name);
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/week';	
	$time_week[$idx] = common_xmlReader($loadxml,$s_name);
}

for ($idx=0; $idx < $sibo_Max; $idx++){
	$s_name = XML_SIBO_PREFIX.($idx+1).'"]/fileCount';
	$file_Max = common_xmlReader($loadxml,$s_name);
	
	for ($i=0; $i < $file_Max; $i++){
		$s_name = XML_SIBO_PREFIX.($idx+1).'"]/file'.($i+1);
		$time_file[$idx][$i] = common_xmlReader($loadxml,$s_name);
		$file_name[$idx] = $file_name[$idx].'['.$time_file[$idx][$i].']&#13;&#10;';
	}
}

function DisplayTitleTdForm($idx)
{
	echo '<td>'.$idx.'</td>';
};

function DisplayTdForm($idx,$end) 
{
	if ($end == '1'){
		echo '<td style="color: #1f8;font-size:10px;word-wrap:break-word;">'.$idx.'</td>';
	}
	else {
		echo '<td style="color: #1f8;font-size:10px;word-wrap:break-word;">'.$idx.'</td>';
	}
};

function isSetHour($str, $hour)
{
	$re = substr($str, $hour, 1);
	if ($re == "0")
	{
		return false;
	}
	else 
	{
		return true;
	}
};

function confirmTime($start,$end){

	for ($i = 0; $i < 24; $i++)
		$temp_hour[$i] = "FF";
	$part_s = explode(":", $start);
	$num = (int)$part_s[0];
	$temp_hour[$num] = $part_s[1];
	$part_e = explode(":", $end);
	$num = (int)$part_e[0];
	if ($temp_hour[$num] != "FF")
	{
		$temp_hour[$num] = $part_e[1];
	}
	$s = (int)$part_s[0];
	$e = (int)$part_e[0];
	if (($e - $s) > 1)
	{
		for ($i = $s+1; $i < ($e-1); $i++)
		{
			$temp_hour[$i] = "**";	
		}
	}  
};

?>

<table border="1" cellspacing="0" style="width: 100%;">
	<thead>
		<tr>
			<td colspan="4">&nbsp;</td>
			<td colspan="24">Hour</td>
			<td colspan="7">Day of the week</td>
		</tr>
		<tr>
			<td colspan=3 >Name</td>
			<td>files</td>
			<?php
				for ($idx = 0; $idx < 24; $idx++) {
					DisplayTitleTdForm($idx);
				}
				for ($idx = 0; $idx < 7; $idx++) {
					DisplayTitleTdForm($dayofWeek[$idx]);
				}
			?>
		</tr>
	</thead>
	<tbody>
		<?php
			$em = "&nbsp;";
			for ($i = 0; $i < $sibo_Max; $i++)
			{
				echo '<tr>';
				echo '<td colspan=3>'.$sibo_file[$i].'</td>';
				echo '<td><span><a href="#" rel="'.$file_name[$i].'" title="'.$file_name[$i].'"><img src="./params/timeSignal/img/file_icon.png" width="22" border="0"></a></span></td>';
//				echo '<td><span><a href="#" class="tooltip" rel="'.$file_name[$i].'" title="'.$file_name[$i].'"><img src="./params/timeSignal/img/file_icon.png" width="22" border="0"></a></span></td>';

				confirmTime($time_start[$i], $time_end[$i]);
				
				$part_s = explode(":", $time_start[$i]);
				$part_e = explode(":", $time_end[$i]);
				
				for ($idx = 0; $idx < 24; $idx++) 
				{
					if ($time_option[$i] == 0)
					{
						if (isSetHour($time_hour[$i], $idx))
						{
							DisplayTdForm($time_min[$i],'0');
						}
						else 
						{
							DisplayTdForm($em.$em,'0');
						}
					}
					else if ($time_option[$i] == 1)
					{
						if ($idx == (int)$part_s[0])
						{
							if ((int)$part_s[0] == (int)$part_e[0])
							{
								DisplayTdForm($part_s[1].' '.$part_e[1],'0');	
							}
							else
							{
								DisplayTdForm($part_s[1],'0');		
							}
							
						}
						else if ($idx == (int)$part_e[0])
						{
							DisplayTdForm($part_e[1],'1');
						}
						else if (($idx > (int)$part_s[0]) && ($idx < (int)$part_e[0]))
						{
							DisplayTdForm("▶",'0');
						}
						else
						{
							DisplayTdForm($em.$em,'0');
						}
					}
				}
				
				for ($idx = 0; $idx < 7; $idx++) 
				{
					if (isSetHour($time_week[$i], $idx))
					{
						DisplayTitleTdForm("●");	
					}
					else 
					{
						DisplayTitleTdForm($em.$em);
					}
				}			
				echo '</tr>';	
			}
		?>
	</tbody>
	<tfoot>
		<tr></tr>
	</tfoot>
</table>
