<?php	
	include "../../common/common_define.php";
	
	$error = "";
	$msg = "";
	$fileElementName = 'fileName';
	
	if(!empty($_FILES[$fileElementName]['error'])) {
		switch($_FILES[$fileElementName]['error']) {

			case '1':
				$error = 'The uploaded file exceeds the upload_max_filesize directive in php.ini';
				break;
			case '2':
				$error = 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form';
				break;
			case '3':
				$error = 'The uploaded file was only partially uploaded';
				break;
			case '4':
				$error = 'No file was uploaded.';
				break;
			case '6':
				$error = 'Missing a temporary folder';
				break;
			case '7':
				$error = 'Failed to write file to disk';
				break;
			case '8':
				$error = 'File upload stopped by extension';
				break;
			case '999':
			default:
				$error = 'No error code avaiable';
		}
	}
	else if(empty($_FILES['fileName']['tmp_name']) || $_FILES['fileName']['tmp_name'] == 'none') {
		$error = 'No file was uploaded..'; 
	}
	else 
	{
		$uploadfile = MP3_PATH .$_FILES['fileName']['name'];
		move_uploaded_file( $_FILES['fileName']['tmp_name'] , $uploadfile);
		
		$loadxml = simplexml_load_file($uploadfile);
		if ($loadxml != "")
		{
			$sibo_use = common_xmlReader($loadxml, XML_SIBO_USE);
			if ($sibo_use == true || $sibo_use == false)
			{
				$sibo_max = common_xmlReader($loadxml, XML_SIBO_MAX);
				if ($sibo_max >= 0)
				{
					rename($uploadfile, "/opt/interm/conf/info_schedule.xml");
					common_logWrite("Schedule file upload!!");			
					$msg .= $uploadfile;						
				}
				if ($sibo_use == true)
				{
					common_KillSibo();
					common_restartSibo();
					unlink($uploadfile);
				}
				else 
				{
					common_KillSibo();
					unlink($uploadfile);
				}
			}
			else
			{
				common_logWrite("file info error");
				unlink($uploadfile);
				$error = "info file error";
			}
		}
		else
		{
			common_logWrite("file info error - xml header ");
			unlink($uploadfile);
			$error = "xml header error";			
		}
	}		
	
	if( $error != "" ) {
		common_logWrite("Schedule info file - ".UPLOAD_FAIL_MSG);
	}
// 이부분이 없으면 넘어가지 않음	
	echo "{";
	echo				"error: '" . $error . "',\n";
	echo				"msg: '" . $msg . "'\n";
	echo "}";	
?>
