<?php
include_once "common/common_define.php";

class Item
{
    protected $_name = '';
	protected $_url = "";
    protected $_next = null;
 
    public function __construct($name, $url)
    {
        $this->_name = $name;
		$this->_url  = $url;
    }
 
    public function setNext(&$next) { $this->_next = $next; }
    public function &getNext() { return $this->_next; }
 
 	public function setName($name) { $this->_name = $name; }
 	public function getName() { return $this->_name; }
	
	public function getUrl() { return $this->_url; }
 
    public function __toString()
    {
        return $this->_name . $this->_url. "\n";
    }
}

class Linked_List 
{
    protected $_head = null;
    protected $_tail = null;
 	protected $_maxLength = 0;
    public function insert($item)
    {
        if ($this->_head == null) {
            $this->_head = $item;
            $this->_tail = $item;
			$this->_maxLength = 1;
            return; 
        }
        $this->_tail->setNext($item);
        $this->_tail = $item;
		$this->_maxLength++;
    } 
 
    public function __toString()
    {
        $current = $this->_head;
        $output = '';
        while ($current) {
            $output .= $current->getName();
			$output .= $current->getUrl();			
            $current = $current->getNext();
        }
         return $output;
    }
	
	public function GetData($index)
	{
		if ($this->_maxLength <= $index)
			return "Max is ". $this->_maxLength;
        $current = $this->_head;
        $output = '';
 		$count = 0;
        while ($current) {
			if ($count == $index){
				$output = $current->getName();
				break;
			}	
			else {
				$current = $current->getNext();
				$count++;
			}			
        }
         return $output;
	}
	
	public function clearNode()
	{
	    $this->_head = null;
    	$this->_tail = null;
 		$this->_maxLength = 0;	
	}
	
	public function GetMaxLength()
	{
		return $this->_maxLength;
	}
}

// for example
$bradcast_info = array();

$bradcast_info[0] = new Linked_List();

$bradcast_info[0]->insert(new Item("name1", "www.naver.com"));
$bradcast_info[0]->insert(new Item("name2", "www.daum.net"));
$bradcast_info[0]->insert(new Item("name3", "www.inter-m.com"));

echo $bradcast_info[0]->GetData(1)."<br>";
echo $bradcast_info[0]->GetMaxLength()."<br>";

$bradcast_info[0]->clearNode();

echo $bradcast_info[0]->GetData(0);
?>




<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
		<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8">
				<link rel="stylesheet" href="/php/css/style.css" type="text/css">

				<meta name="author"		content="Inter-M">
				<meta name="keywords"	content="Audio">
		</head>

		<body>
			<table border="0" cellpadding="0" cellspacing="0" width="800" height="100%">
				<tr>
					<td width="800" colspan="3">
					<?include "params/top.php" ?>
					</td>
				</tr>

				<tr>
					<td class="menu_bg" width="200" valign="top">
						<?include "params/menu.php" ?>
					</td>

					<td width="600" valign="top" style="padding:10">
						<p class="header_font"> <?=RADIO_CONN_SETUP ?> </p>
						<form name="mainForm" action=<?=$_SERVER["REQUEST_URI"]?> target="_self" method="POST">
						<input type="hidden" name="formSubmit" value="on">

							<!-- menu block -->
							<?include "params/radio/Copy of radio_main.php" ?>
							
							<!-- submit or reset block --> 
							<table border="0" cellpadding="2" width="615">
									<td align="RIGHT">
											<input type="submit" value="<?=SUBMIT_SET_BUTTON ?>"   onclick="return SubmitForm(this.form)">
											<input type="reset"	 value="<?=SUBMIT_CLEAR_BUTTON ?>" onclick="ResetForm(this.form)">
									</td>
							</table>
						</form>

						<!-- display help&tip block -->
						<?=common_displayHelp(	SYSTEM_CONNET_VALUE_MSG )?>
						
				
						<!-- display copyright block -->
						<?include "params/copyright.php" ?>
					</td>
				</tr>
			</table> 
		</body>
</html>



<script language="JavaScript"> 

</script>
