<?php
	include "common/common_define.php";

	function GetCountEntry() {
		$xml = simplexml_load_file(RADIO_USER_CATEGORY_XML);
		
		$idx = 0 ;
		foreach($xml->channels->entry as $result) {
			$idx++;
		}
		
		return $idx;
	}

	function AddEntry($title, $url) {
		$file = RADIO_USER_CATEGORY_XML;
		$xml = simplexml_load_file($file);
		
		$nodeExists = $xml->xpath(RADIO_CHANNEL_PATH);
		$newItem = $nodeExists[0][0]->addChild("entry");
		$newItem->addChild("title", $title);
		$newItem->addChild("url", $url);
		
		$xml->asXML($file);
		
		return 0;
	};

	function RemoveEntry($title) {
		$file = RADIO_USER_CATEGORY_XML;
		$xml = simplexml_load_file($file);
		$idx = 0;
		foreach($xml->channels->entry as $result) {
			if( strcmp($result->title, $title) == 0 ) {
				unset($xml->channels->entry[$idx]);
				$xml->asXML($file);
				
				return 0;
			}
			$idx++;
		}
		
		return -1;
	};
	
	$radio_xmlFile = RADIO_USER_CATEGORY_XML;
	$xml = simplexml_load_file("/opt/interm/conf/user_channels.xml");
	
	var_dump($xml);

	echo $xml->channels->entry[0]->title;
	echo $xml->channels->entry[0]->url;
	echo $xml->channels->entry[0]->index;
	
?>


